/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.dbcp.hibernate;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.dbcp.AnterosDBCPConfig;
import br.com.anteros.dbcp.AnterosDBCPDataSource;
import br.com.anteros.dbcp.hibernate.AnterosDBCPConfigurationUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class AnterosDBCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private static final Logger LOGGER = LoggerProvider.getInstance().getLogger(AnterosDBCPConnectionProvider.class.getName());
    private AnterosDBCPConfig hcfg = null;
    private AnterosDBCPDataSource hds = null;

    public AnterosDBCPConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") >= 1) {
            LOGGER.warn((Object)"br.com.anteros.dbcp.hibernate.AnterosDBCPConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.AnterosDBCPCPConnectionProvider.");
        }
    }

    public void configure(Map props) throws HibernateException {
        try {
            LOGGER.debug((Object)"Configuring AnterosDBCPCP");
            this.hcfg = AnterosDBCPConfigurationUtil.loadConfiguration(props);
            this.hds = new AnterosDBCPDataSource(this.hcfg);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
        LOGGER.debug((Object)"AnterosDBCPCP Configured");
    }

    public Connection getConnection() throws SQLException {
        Connection conn = null;
        if (this.hds != null) {
            conn = this.hds.getConnection();
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || AnterosDBCPConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || AnterosDBCPConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.hds;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        this.hds.close();
    }
}

