/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv.bean.concurrent;

import br.com.anteros.csv.bean.BeanField;
import br.com.anteros.csv.bean.MappingStrategy;
import br.com.anteros.csv.bean.concurrent.OrderedObject;
import br.com.anteros.csv.bean.opencsvUtils;
import br.com.anteros.exceptions.CsvBeanIntrospectionException;
import br.com.anteros.exceptions.CsvDataTypeMismatchException;
import br.com.anteros.exceptions.CsvException;
import br.com.anteros.exceptions.CsvRequiredFieldEmptyException;
import br.com.anteros.exceptions.CsvRuntimeException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ProcessCsvBean<T>
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mappingStrategy;
    private final T bean;
    private final BlockingQueue<OrderedObject<String[]>> resultantLineQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;
    private final List<String> contents = new ArrayList<String>();
    private final Locale errorLocale;

    public ProcessCsvBean(long lineNumber, MappingStrategy<T> mappingStrategy, T bean, BlockingQueue<OrderedObject<String[]>> resultantLineQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions, Locale errorLocale) {
        this.lineNumber = lineNumber;
        this.mappingStrategy = mappingStrategy;
        this.bean = bean;
        this.resultantLineQueue = resultantLineQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
    }

    private void writeWithReflection(int numColumns) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        for (int i = 0; i <= numColumns; ++i) {
            BeanField beanField = this.mappingStrategy.findField(i);
            String s = beanField != null ? beanField.write(this.bean) : "";
            this.contents.add(StringUtils.defaultString((String)s));
        }
    }

    private void writeWithIntrospection(int numColumns) {
        for (int i = 0; i <= numColumns; ++i) {
            try {
                PropertyDescriptor desc = this.mappingStrategy.findDescriptor(i);
                Object o = desc != null ? desc.getReadMethod().invoke(this.bean, (Object[])null) : null;
                this.contents.add(Objects.toString(o, ""));
                continue;
            }
            catch (Exception e) {
                CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(this.bean, null, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("error.introspecting.beans"));
                csve.initCause(e);
                throw csve;
            }
        }
    }

    @Override
    public void run() {
        try {
            int numColumns = this.mappingStrategy.findMaxFieldIndex();
            if (this.mappingStrategy.isAnnotationDriven()) {
                this.writeWithReflection(numColumns);
            } else {
                this.writeWithIntrospection(numColumns);
            }
            opencsvUtils.queueRefuseToAcceptDefeat(this.resultantLineQueue, new OrderedObject<String[]>(this.lineNumber, this.contents.toArray(new String[this.contents.size()])));
        }
        catch (CsvException e) {
            CsvException csve = e;
            csve.setLineNumber(this.lineNumber);
            if (this.throwExceptions) {
                throw new RuntimeException(csve);
            }
            opencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, csve));
        }
        catch (CsvRuntimeException csvre) {
            throw csvre;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }
}

