/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv.bean;

import br.com.anteros.csv.bean.MappingStrategy;
import br.com.anteros.csv.bean.StatefulBeanToCsv;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

public class StatefulBeanToCsvBuilder<T> {
    private char separator = (char)44;
    private char quotechar = (char)34;
    private char escapechar = (char)34;
    private String lineEnd = "\n";
    private MappingStrategy<T> mappingStrategy = null;
    private final Writer writer;
    private boolean throwExceptions = true;
    private boolean orderedResults = true;
    private Locale errorLocale = Locale.getDefault();

    private StatefulBeanToCsvBuilder() {
        throw new IllegalStateException(String.format(ResourceBundle.getBundle("opencsv").getString("nullary.constructor.not.allowed"), this.getClass().getName()));
    }

    public StatefulBeanToCsvBuilder(Writer writer) {
        this.writer = writer;
    }

    public StatefulBeanToCsvBuilder<T> withMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withQuotechar(char quotechar) {
        this.quotechar = quotechar;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withEscapechar(char escapechar) {
        this.escapechar = escapechar;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withOrderedResults(boolean orderedResults) {
        this.orderedResults = orderedResults;
        return this;
    }

    public StatefulBeanToCsvBuilder<T> withErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
        return this;
    }

    public StatefulBeanToCsv<T> build() {
        StatefulBeanToCsv<T> sbtcsv = new StatefulBeanToCsv<T>(this.escapechar, this.lineEnd, this.mappingStrategy, this.quotechar, this.separator, this.throwExceptions, this.writer);
        sbtcsv.setOrderedResults(this.orderedResults);
        sbtcsv.setErrorLocale(this.errorLocale);
        return sbtcsv;
    }
}

