/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv.bean;

import br.com.anteros.csv.AnterosCSVReader;
import br.com.anteros.csv.bean.AbstractCSVToBean;
import br.com.anteros.csv.bean.CsvToBeanFilter;
import br.com.anteros.csv.bean.MappingStrategy;
import br.com.anteros.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

@Deprecated
public class IterableCSVToBean<T>
extends AbstractCSVToBean
implements Iterable<T> {
    private final MappingStrategy<T> strategy;
    private final AnterosCSVReader csvReader;
    private final CsvToBeanFilter filter;
    private boolean hasHeader;
    private Locale errorLocale = Locale.getDefault();

    public IterableCSVToBean(AnterosCSVReader csvReader, MappingStrategy<T> strategy, CsvToBeanFilter filter) {
        this.csvReader = csvReader;
        this.strategy = strategy;
        this.filter = filter;
        this.hasHeader = false;
    }

    protected MappingStrategy<T> getStrategy() {
        return this.strategy;
    }

    protected AnterosCSVReader getCSVReader() {
        return this.csvReader;
    }

    protected CsvToBeanFilter getFilter() {
        return this.filter;
    }

    public T nextLine() throws IllegalAccessException, InstantiationException, IOException, IntrospectionException, InvocationTargetException, CsvRequiredFieldEmptyException {
        String[] line;
        if (!this.hasHeader) {
            this.strategy.captureHeader(this.csvReader);
            this.hasHeader = true;
        }
        T bean = null;
        while ((line = this.csvReader.readNext()) != null && this.filter != null && !this.filter.allowLine(line)) {
        }
        if (line != null) {
            this.strategy.verifyLineLength(line.length);
            bean = this.strategy.createBean();
            for (int col = 0; col < line.length; ++col) {
                PropertyDescriptor prop = this.strategy.findDescriptor(col);
                if (null == prop) continue;
                String value = this.checkForTrim(line[col], prop);
                Object obj = this.convertValue(value, prop);
                prop.getWriteMethod().invoke(bean, obj);
            }
        }
        return bean;
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this);
    }

    private Iterator<T> iterator(final IterableCSVToBean<T> bean) {
        return new Iterator<T>(){
            private T nextBean;

            @Override
            public boolean hasNext() {
                if (this.nextBean != null) {
                    return true;
                }
                try {
                    this.nextBean = bean.nextLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.nextBean != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object holder = this.nextBean;
                this.nextBean = null;
                return holder;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", IterableCSVToBean.this.errorLocale).getString("read.only.iterator"));
            }
        };
    }
}

