/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv.bean;

import br.com.anteros.csv.AnterosCSVReader;
import br.com.anteros.csv.bean.AbstractBeanField;
import br.com.anteros.csv.bean.BeanField;
import br.com.anteros.csv.bean.BeanFieldDate;
import br.com.anteros.csv.bean.BeanFieldPrimitiveTypes;
import br.com.anteros.csv.bean.CsvBindByPosition;
import br.com.anteros.csv.bean.CsvCustomBindByPosition;
import br.com.anteros.csv.bean.CsvDate;
import br.com.anteros.csv.bean.HeaderColumnNameMappingStrategy;
import br.com.anteros.exceptions.CsvBadConverterException;
import br.com.anteros.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class ColumnPositionMappingStrategy<T>
extends HeaderColumnNameMappingStrategy<T> {
    private String[] columnMapping = new String[0];
    private boolean columnsExplicitlySet = false;

    @Override
    public void captureHeader(AnterosCSVReader reader) throws IOException {
    }

    @Override
    public String[] generateHeader() {
        return new String[0];
    }

    @Override
    public Integer getColumnIndex(String name) {
        return (Integer)this.indexLookup.get(name);
    }

    @Override
    public int findMaxFieldIndex() {
        return this.columnMapping == null ? -1 : this.columnMapping.length - 1;
    }

    @Override
    public String getColumnName(int col) {
        return col < this.columnMapping.length ? this.columnMapping[col] : null;
    }

    public String[] getColumnMapping() {
        return (String[])this.columnMapping.clone();
    }

    public void setColumnMapping(String ... columnMapping) {
        this.columnMapping = columnMapping != null ? (String[])columnMapping.clone() : new String[]{};
        this.resetIndexMap();
        this.createIndexLookup(this.columnMapping);
        this.columnsExplicitlySet = true;
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        super.setType(type);
        if (!this.columnsExplicitlySet) {
            TreeMap<Integer, BeanField> cols = new TreeMap<Integer, BeanField>();
            for (BeanField beanField : this.fieldMap.values()) {
                if (beanField.getField().getAnnotation(CsvCustomBindByPosition.class) != null) {
                    cols.put(beanField.getField().getAnnotation(CsvCustomBindByPosition.class).position(), beanField);
                    continue;
                }
                if (beanField.getField().getAnnotation(CsvBindByPosition.class) == null) continue;
                cols.put(beanField.getField().getAnnotation(CsvBindByPosition.class).position(), beanField);
            }
            if (!cols.isEmpty()) {
                this.columnMapping = new String[(Integer)cols.lastKey() + 1];
                for (Map.Entry entry : cols.entrySet()) {
                    this.columnMapping[((Integer)entry.getKey()).intValue()] = ((BeanField)entry.getValue()).getField().getName().toUpperCase().trim();
                }
                this.resetIndexMap();
                this.createIndexLookup(this.columnMapping);
            } else {
                this.columnMapping = new String[0];
            }
        }
    }

    @Override
    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap();
        for (Field field : this.loadFields(this.getType())) {
            boolean required;
            Annotation annotation;
            String columnName;
            if (field.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                columnName = field.getName().toUpperCase().trim();
                annotation = field.getAnnotation(CsvCustomBindByPosition.class);
                Class<? extends AbstractBeanField> converter = annotation.converter();
                BeanField bean = this.instantiateCustomConverter(converter);
                bean.setField(field);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            annotation = field.getAnnotation(CsvBindByPosition.class);
            required = annotation.required();
            columnName = field.getName().toUpperCase().trim();
            String fieldLocale = annotation.locale();
            if (field.isAnnotationPresent(CsvDate.class)) {
                String formatString = field.getAnnotation(CsvDate.class).value();
                this.fieldMap.put(columnName, new BeanFieldDate(field, required, formatString, fieldLocale, this.errorLocale));
                continue;
            }
            this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, fieldLocale, this.errorLocale));
        }
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (this.columnMapping != null) {
            StringBuilder sb = null;
            for (int i = numberOfFields; i < this.columnMapping.length; ++i) {
                BeanField f = this.findField(i);
                if (f == null || !f.isRequired()) continue;
                if (sb == null) {
                    sb = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiple.required.field.empty"));
                }
                sb.append(' ');
                sb.append(f.getField().getName());
            }
            if (sb != null) {
                throw new CsvRequiredFieldEmptyException(this.type, sb.toString());
            }
        }
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CsvBindByPosition.class) && !field.isAnnotationPresent(CsvCustomBindByPosition.class)) continue;
            fields.add(field);
        }
        this.annotationDriven = !fields.isEmpty();
        return fields;
    }
}

