/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv.bean;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCSVToBean {
    private Map<Class<?>, PropertyEditor> editorMap = null;

    protected abstract PropertyEditor getPropertyEditor(PropertyDescriptor var1) throws InstantiationException, IllegalAccessException;

    protected String checkForTrim(String s, PropertyDescriptor prop) {
        return s != null && this.trimmableProperty(prop) ? s.trim() : s;
    }

    private boolean trimmableProperty(PropertyDescriptor prop) {
        return !prop.getPropertyType().getName().contains("String");
    }

    protected Object convertValue(String value, PropertyDescriptor prop) throws InstantiationException, IllegalAccessException {
        PropertyEditor editor = this.getPropertyEditor(prop);
        Object obj = value;
        if (null != editor) {
            editor.setAsText(value);
            obj = editor.getValue();
        }
        return obj;
    }

    protected PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor editor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((editor = this.editorMap.get(cls)) == null) {
            editor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, editor);
        }
        return editor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor editor) {
        if (editor != null) {
            this.editorMap.put(cls, editor);
        }
    }
}

