/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv;

import br.com.anteros.csv.ResultSetHelper;
import br.com.anteros.csv.ResultSetHelperService;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class CSVWriter
implements Closeable,
Flushable {
    public static final int INITIAL_STRING_SIZE = 1024;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    public static final String RFC4180_LINE_END = "\r\n";
    protected final Writer writer;
    protected final char separator;
    protected final char quotechar;
    protected final char escapechar;
    protected String lineEnd;
    protected ResultSetHelper resultService;
    protected volatile IOException exception;

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.writer = writer;
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(Iterable<String[]> allLines, boolean applyQuotesToAll) {
        StringBuilder sb = new StringBuilder(1024);
        try {
            for (String[] line : allLines) {
                this.writeNext(line, applyQuotesToAll, sb);
                sb.setLength(0);
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public void writeAll(List<String[]> allLines, boolean applyQuotesToAll) {
        this.writeAll((Iterable<String[]>)allLines, applyQuotesToAll);
    }

    public void writeAll(Iterable<String[]> allLines) {
        StringBuilder sb = new StringBuilder(1024);
        try {
            for (String[] line : allLines) {
                this.writeNext(line, true, sb);
                sb.setLength(0);
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public void writeAll(List<String[]> allLines) {
        this.writeAll((Iterable<String[]>)allLines);
    }

    protected void writeColumnNames(ResultSet rs, boolean applyQuotesToAll) throws SQLException {
        this.writeNext(this.resultService().getColumnNames(rs), applyQuotesToAll);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        return this.writeAll(rs, includeColumnNames, false, true);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames, boolean trim) throws SQLException, IOException {
        return this.writeAll(rs, includeColumnNames, trim, true);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames, boolean trim, boolean applyQuotesToAll) throws SQLException, IOException {
        int linesWritten = 0;
        if (includeColumnNames) {
            this.writeColumnNames(rs, applyQuotesToAll);
            ++linesWritten;
        }
        while (rs.next()) {
            this.writeNext(this.resultService().getColumnValues(rs, trim), applyQuotesToAll);
            ++linesWritten;
        }
        return linesWritten;
    }

    public void writeNext(String[] nextLine, boolean applyQuotesToAll) {
        try {
            this.writeNext(nextLine, applyQuotesToAll, new StringBuilder(1024));
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    protected void writeNext(String[] nextLine, boolean applyQuotesToAll, Appendable appendable) throws IOException {
        if (nextLine == null) {
            return;
        }
        int i = 0;
        while (i < nextLine.length) {
            String nextElement;
            if (i != 0) {
                appendable.append(this.separator);
            }
            if ((nextElement = nextLine[i]) != null) {
                Boolean stringContainsSpecialCharacters = this.stringContainsSpecialCharacters(nextElement);
                if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
                    appendable.append(this.quotechar);
                }
                if (stringContainsSpecialCharacters.booleanValue()) {
                    this.processLine(nextElement, appendable);
                } else {
                    appendable.append(nextElement);
                }
                if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
                    appendable.append(this.quotechar);
                }
            }
            ++i;
        }
        appendable.append(this.lineEnd);
        this.writer.write(appendable.toString());
    }

    public void writeNext(String[] nextLine) {
        this.writeNext(nextLine, true);
    }

    protected boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1 || line.indexOf(this.separator) != -1 || line.contains(DEFAULT_LINE_END) || line.contains("\r");
    }

    protected void processLine(String nextElement, Appendable appendable) throws IOException {
        int j = 0;
        while (j < nextElement.length()) {
            char nextChar = nextElement.charAt(j);
            this.processCharacter(appendable, nextChar);
            ++j;
        }
    }

    protected void processCharacter(Appendable appendable, char nextChar) throws IOException {
        if (this.escapechar != '\u0000' && this.checkCharactersToEscape(nextChar)) {
            appendable.append(this.escapechar);
        }
        appendable.append(nextChar);
    }

    protected boolean checkCharactersToEscape(char nextChar) {
        return this.quotechar == '\u0000' ? nextChar == this.quotechar || nextChar == this.escapechar || nextChar == this.separator || nextChar == '\n' : nextChar == this.quotechar || nextChar == this.escapechar;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public boolean checkError() {
        if (this.writer instanceof PrintWriter) {
            PrintWriter pw = (PrintWriter)this.writer;
            return pw.checkError();
        }
        this.flushQuietly();
        return this.exception != null;
    }

    public void setResultService(ResultSetHelper resultService) {
        this.resultService = resultService;
    }

    protected ResultSetHelper resultService() {
        if (this.resultService == null) {
            this.resultService = new ResultSetHelperService();
        }
        return this.resultService;
    }

    public void flushQuietly() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

