/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.csv;

import br.com.anteros.csv.AnterosCSVParserBuilder;
import br.com.anteros.csv.AnterosCSVReader;
import br.com.anteros.csv.ICSVParser;
import br.com.anteros.enums.CSVReaderNullFieldIndicator;
import java.io.Reader;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

public class AnterosCSVReaderBuilder {
    private final AnterosCSVParserBuilder parserBuilder = new AnterosCSVParserBuilder();
    private final Reader reader;
    private int skipLines = 0;
    private ICSVParser icsvParser = null;
    private boolean keepCR;
    private boolean verifyReader = true;
    private CSVReaderNullFieldIndicator nullFieldIndicator = CSVReaderNullFieldIndicator.NEITHER;
    private int multilineLimit = 0;
    private Locale errorLocale = Locale.getDefault();

    public AnterosCSVReaderBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle("opencsv").getString("reader.null"));
        }
        this.reader = reader;
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected int getSkipLines() {
        return this.skipLines;
    }

    protected ICSVParser getCsvParser() {
        return this.icsvParser;
    }

    protected int getMultilineLimit() {
        return this.multilineLimit;
    }

    public AnterosCSVReaderBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines <= 0 ? 0 : skipLines;
        return this;
    }

    public AnterosCSVReaderBuilder withCSVParser(ICSVParser icsvParser) {
        this.icsvParser = icsvParser;
        return this;
    }

    public AnterosCSVReader build() {
        ICSVParser parser = (ICSVParser)ObjectUtils.defaultIfNull((Object)this.icsvParser, (Object)this.parserBuilder.withFieldAsNull(this.nullFieldIndicator).withErrorLocale(this.errorLocale).build());
        return new AnterosCSVReader(this.reader, this.skipLines, parser, this.keepCR, this.verifyReader, this.multilineLimit, this.errorLocale);
    }

    public AnterosCSVReaderBuilder withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    protected boolean keepCarriageReturn() {
        return this.keepCR;
    }

    public AnterosCSVReaderBuilder withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }

    public AnterosCSVReaderBuilder withFieldAsNull(CSVReaderNullFieldIndicator indicator) {
        this.nullFieldIndicator = indicator;
        return this;
    }

    public AnterosCSVReaderBuilder withMultilineLimit(int multilineLimit) {
        this.multilineLimit = multilineLimit;
        return this;
    }

    public AnterosCSVReaderBuilder withErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
        return this;
    }
}

