/*
 * Decompiled with CFR 0.152.
 */
package br.com.aniche.ck.metric;

import br.com.aniche.ck.CKNumber;
import br.com.aniche.ck.CKReport;
import br.com.aniche.ck.metric.Metric;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.WhileStatement;

public class WMC
extends ASTVisitor
implements Metric {
    protected int cc = 0;

    public boolean visit(MethodDeclaration node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(ForStatement node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(EnhancedForStatement node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(ConditionalExpression node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(DoStatement node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(WhileStatement node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(SwitchCase node) {
        if (!node.isDefault()) {
            this.increaseCc();
        }
        return super.visit(node);
    }

    public boolean visit(Initializer node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(CatchClause node) {
        this.increaseCc();
        return super.visit(node);
    }

    public boolean visit(IfStatement node) {
        String expr = node.getExpression().toString().replace("&&", "&").replace("||", "|");
        int ands = StringUtils.countMatches((CharSequence)expr, (CharSequence)"&");
        int ors = StringUtils.countMatches((CharSequence)expr, (CharSequence)"|");
        this.increaseCc(ands + ors);
        this.increaseCc();
        return super.visit(node);
    }

    private void increaseCc() {
        this.increaseCc(1);
    }

    protected void increaseCc(int qtd) {
        ++this.cc;
    }

    @Override
    public void execute(CompilationUnit cu, CKReport report) {
        cu.accept((ASTVisitor)this);
    }

    @Override
    public void setResult(CKNumber result) {
        result.setWmc(this.cc);
    }
}

