/*
 * Decompiled with CFR 0.152.
 */
package br.com.aniche.ck;

import br.com.aniche.ck.CKReport;
import br.com.aniche.ck.FileUtils;
import br.com.aniche.ck.MetricsExecutor;
import br.com.aniche.ck.metric.CBO;
import br.com.aniche.ck.metric.DIT;
import br.com.aniche.ck.metric.LCOM;
import br.com.aniche.ck.metric.Metric;
import br.com.aniche.ck.metric.NOC;
import br.com.aniche.ck.metric.NOM;
import br.com.aniche.ck.metric.RFC;
import br.com.aniche.ck.metric.WMC;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class CK {
    private static final int MAX_AT_ONCE;
    public List<Callable<Metric>> pluggedMetrics = new ArrayList<Callable<Metric>>();
    private static Logger log;

    public CK plug(Callable<Metric> metric) {
        this.pluggedMetrics.add(metric);
        return this;
    }

    public CKReport calculate(String path) {
        String[] srcDirs = FileUtils.getAllDirs(path);
        String[] javaFiles = FileUtils.getAllJavaFiles(path);
        log.info((Object)("Found " + javaFiles.length + " java files"));
        MetricsExecutor storage = new MetricsExecutor(() -> this.metrics());
        List partitions = Lists.partition(Arrays.asList(javaFiles), (int)MAX_AT_ONCE);
        log.info((Object)("Max partition size: " + MAX_AT_ONCE + ", total partitions=" + partitions.size()));
        for (List partition : partitions) {
            log.info((Object)"Next partition");
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setResolveBindings(true);
            parser.setBindingsRecovery(true);
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions((String)"1.8", (Map)options);
            parser.setCompilerOptions((Map)options);
            parser.setEnvironment(null, srcDirs, null, true);
            parser.createASTs(partition.toArray(new String[partition.size()]), null, new String[0], (FileASTRequestor)storage, null);
        }
        log.info((Object)"Finished parsing");
        return storage.getReport();
    }

    private List<Metric> metrics() {
        List<Metric> all = this.defaultMetrics();
        all.addAll(this.userMetrics());
        return all;
    }

    private List<Metric> defaultMetrics() {
        return new ArrayList<ASTVisitor>(Arrays.asList(new DIT(), new NOC(), new WMC(), new CBO(), new LCOM(), new RFC(), new NOM()));
    }

    private List<Metric> userMetrics() {
        try {
            ArrayList<Metric> userMetrics = new ArrayList<Metric>();
            for (Callable<Metric> metricToBeCreated : this.pluggedMetrics) {
                userMetrics.add(metricToBeCreated.call());
            }
            return userMetrics;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        MAX_AT_ONCE = maxMemory >= 2000L ? 400 : (maxMemory >= 1500L ? 300 : (maxMemory >= 1000L ? 200 : (maxMemory >= 500L ? 100 : 25)));
        log = Logger.getLogger(CK.class);
    }
}

