/*
 * Decompiled with CFR 0.152.
 */
package br.com.aniche.ck.metric;

import br.com.aniche.ck.CKNumber;
import br.com.aniche.ck.CKReport;
import br.com.aniche.ck.metric.Metric;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class CBO
extends ASTVisitor
implements Metric {
    private Set<String> coupling = new HashSet<String>();

    public boolean visit(VariableDeclarationStatement node) {
        this.coupleTo(node.getType().resolveBinding());
        return super.visit(node);
    }

    public boolean visit(ArrayCreation node) {
        this.coupleTo(node.getType().resolveBinding());
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        this.coupleTo(node.getType().resolveBinding());
        return super.visit(node);
    }

    public boolean visit(ReturnStatement node) {
        if (node.getExpression() != null) {
            this.coupleTo(node.getExpression().resolveTypeBinding());
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            for (ITypeBinding t : binding.getParameterTypes()) {
                this.coupleTo(t);
            }
        }
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        this.coupleTo(node.getExpression().resolveTypeBinding());
        return super.visit(node);
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding type = node.resolveBinding();
        ITypeBinding binding = type.getSuperclass();
        if (binding != null) {
            this.coupleTo(binding);
        }
        for (ITypeBinding interfaces : type.getInterfaces()) {
            this.coupleTo(interfaces);
        }
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        IMethodBinding method = node.resolveBinding();
        if (method == null) {
            return super.visit(node);
        }
        this.coupleTo(method.getReturnType());
        for (ITypeBinding param : method.getParameterTypes()) {
            this.coupleTo(param);
        }
        return super.visit(node);
    }

    public boolean visit(CastExpression node) {
        this.coupleTo(node.getType().resolveBinding());
        return super.visit(node);
    }

    public boolean visit(InstanceofExpression node) {
        this.coupleTo(node.getRightOperand().resolveBinding());
        this.coupleTo(node.getLeftOperand().resolveTypeBinding());
        return super.visit(node);
    }

    public boolean visit(NormalAnnotation node) {
        this.coupleTo(node.resolveTypeBinding());
        return super.visit(node);
    }

    public boolean visit(MarkerAnnotation node) {
        this.coupleTo(node.resolveTypeBinding());
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.coupleTo(node.resolveTypeBinding());
        return super.visit(node);
    }

    public boolean visit(ParameterizedType node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding == null) {
            return super.visit(node);
        }
        this.coupleTo(binding);
        for (ITypeBinding types : binding.getTypeArguments()) {
            this.coupleTo(types);
        }
        return super.visit(node);
    }

    private void coupleTo(ITypeBinding binding) {
        if (binding == null) {
            return;
        }
        if (binding.isWildcardType()) {
            return;
        }
        String type = binding.getQualifiedName();
        if (!this.isFromJava(type) && !binding.isPrimitive()) {
            this.coupling.add(type.replace("[]", ""));
        }
    }

    private boolean isFromJava(String type) {
        return type.startsWith("java.") || type.startsWith("javax.");
    }

    @Override
    public void execute(CompilationUnit cu, CKReport report) {
        cu.accept((ASTVisitor)this);
    }

    @Override
    public void setResult(CKNumber result) {
        result.setCbo(this.coupling.size());
    }
}

