/*
 * Decompiled with CFR 0.152.
 */
package br.com.aniche.ck;

import br.com.aniche.ck.CKNumber;
import br.com.aniche.ck.CKReport;
import br.com.aniche.ck.metric.ClassInfo;
import br.com.aniche.ck.metric.Metric;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class MetricsExecutor
extends FileASTRequestor {
    private CKReport report;
    private Callable<List<Metric>> metrics;
    private static Logger log = Logger.getLogger(MetricsExecutor.class);

    public MetricsExecutor(Callable<List<Metric>> metrics) {
        this.metrics = metrics;
        this.report = new CKReport();
    }

    public void acceptAST(String sourceFilePath, CompilationUnit cu) {
        log.info((Object)("accepted " + sourceFilePath));
        try {
            ClassInfo info = new ClassInfo();
            cu.accept((ASTVisitor)info);
            if (info.getClassName() == null) {
                return;
            }
            CKNumber result = new CKNumber(sourceFilePath, info.getClassName());
            for (Metric visitor : this.metrics.call()) {
                visitor.execute(cu, this.report);
                visitor.setResult(result);
            }
            log.info((Object)result);
            this.report.add(result);
        }
        catch (Exception e) {
            log.error((Object)("error in " + sourceFilePath), (Throwable)e);
        }
    }

    public CKReport getReport() {
        return this.report;
    }
}

