/*
 * Decompiled with CFR 0.152.
 */
package br.com.aniche.ck;

import br.com.aniche.ck.CKReport;
import br.com.aniche.ck.FileUtils;
import br.com.aniche.ck.MetricsExecutor;
import br.com.aniche.ck.metric.CBO;
import br.com.aniche.ck.metric.DIT;
import br.com.aniche.ck.metric.LCOM;
import br.com.aniche.ck.metric.Metric;
import br.com.aniche.ck.metric.NOC;
import br.com.aniche.ck.metric.NOM;
import br.com.aniche.ck.metric.RFC;
import br.com.aniche.ck.metric.WMC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class CK {
    public List<Callable<Metric>> pluggedMetrics = new ArrayList<Callable<Metric>>();
    private static Logger log = Logger.getLogger(CK.class);

    public CK plug(Callable<Metric> metric) {
        this.pluggedMetrics.add(metric);
        return this;
    }

    public CKReport calculate(String path) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        parser.setCompilerOptions((Map)options);
        String[] srcDirs = FileUtils.getAllDirs(path);
        String[] javaFiles = FileUtils.getAllJavaFiles(path);
        log.info((Object)("Found " + javaFiles.length + " java files"));
        parser.setEnvironment(null, srcDirs, null, true);
        MetricsExecutor storage = new MetricsExecutor(() -> this.metrics());
        parser.createASTs(javaFiles, null, new String[0], (FileASTRequestor)storage, null);
        log.info((Object)"Finished parsing");
        return storage.getReport();
    }

    private List<Metric> metrics() {
        List<Metric> all = this.defaultMetrics();
        all.addAll(this.userMetrics());
        return all;
    }

    private List<Metric> defaultMetrics() {
        return new ArrayList<ASTVisitor>(Arrays.asList(new DIT(), new NOC(), new WMC(), new CBO(), new LCOM(), new RFC(), new NOM()));
    }

    private List<Metric> userMetrics() {
        try {
            ArrayList<Metric> userMetrics = new ArrayList<Metric>();
            for (Callable<Metric> metricToBeCreated : this.pluggedMetrics) {
                userMetrics.add(metricToBeCreated.call());
            }
            return userMetrics;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

