package com.ebanx.testlib;

import android.content.Context;

import com.google.gson.JsonObject;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;

public final class MyLib {

    public MyLib() {}

    public String getVersion() {
        return "1.0.0";
    }

    public static void request(Context context, final MyLibResult callback) {
        Ion.with(context)
                .load("https://httpbin.org/get")
                .asJsonObject()
                .setCallback(new FutureCallback<JsonObject>() {
                    @Override
                    public void onCompleted(Exception e, JsonObject result) {
                        callback.onCompleted(e, result);
                    }
                });
    }

    public interface MyLibResult<T> {
        void onCompleted(Exception e, T result);
    }
}


