/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib.util;

import java.util.ArrayList;
import java.util.List;
import walker.blue.path.lib.floor.FloorConnector;
import walker.blue.path.lib.node.GridNode;

public class GridGenerator {
    private GridGenerator() {
    }

    public static List<List<GridNode>> gen2D(char[][] grid) {
        return GridGenerator.gen2D(grid, 0);
    }

    public static List<List<GridNode>> gen2D(char[][] grid, int floor) {
        ArrayList<List<GridNode>> generatedGrid = new ArrayList<List<GridNode>>();
        int y = 0;
        for (char[] xRow : grid) {
            ArrayList<GridNode> currentXRow = new ArrayList<GridNode>();
            int x = 0;
            for (char type : xRow) {
                switch (type) {
                    case 'O': {
                        currentXRow.add(new GridNode(x, y, floor, true));
                        break;
                    }
                    case 'X': {
                        currentXRow.add(new GridNode(x, y, floor, false));
                        break;
                    }
                    case 'E': {
                        currentXRow.add(new FloorConnector(x, y, floor, false, FloorConnector.Type.ELEVATOR));
                        break;
                    }
                    case 'S': {
                        currentXRow.add(new FloorConnector(x, y, floor, false, FloorConnector.Type.STAIRS));
                        break;
                    }
                    default: {
                        currentXRow.add(new GridNode(x, y, floor, false));
                    }
                }
                ++x;
            }
            generatedGrid.add(currentXRow);
            ++y;
        }
        return generatedGrid;
    }

    public static List<List<List<GridNode>>> gen3D(char[][][] grid3D) {
        ArrayList<List<List<GridNode>>> generatedGrid3D = new ArrayList<List<List<GridNode>>>();
        int z = 0;
        for (char[][] floor : grid3D) {
            generatedGrid3D.add(GridGenerator.gen2D(floor, z));
            ++z;
        }
        return generatedGrid3D;
    }
}

