/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib.node;

import walker.blue.path.lib.node.RectCoordinates;

public class NodeMapper {
    private double nodeDistance;
    private double floorHeight;

    public NodeMapper(double nodeDistance, double floorHeight) {
        this.nodeDistance = nodeDistance;
        this.floorHeight = floorHeight;
    }

    public RectCoordinates getGridLocation(RectCoordinates realLoc) {
        int xIndex = (int)((double)realLoc.getY() / this.nodeDistance);
        int yIndex = (int)((double)realLoc.getX() / this.nodeDistance);
        int zIndex = (int)((double)realLoc.getZ() / this.floorHeight);
        return new RectCoordinates(xIndex, yIndex, zIndex);
    }

    public RectCoordinates getRealLocation(RectCoordinates gridLocation) {
        int xLoc = (int)((double)gridLocation.getX() * this.nodeDistance);
        int yLoc = (int)((double)gridLocation.getY() * this.nodeDistance);
        int zLoc = (int)((double)gridLocation.getZ() * this.floorHeight);
        return new RectCoordinates(xLoc, yLoc, zLoc);
    }

    public double getNodeDistance() {
        return this.nodeDistance;
    }

    public double getFloorHeight() {
        return this.floorHeight;
    }
}

