/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib.floor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import walker.blue.path.lib.finder.GridAStar;
import walker.blue.path.lib.floor.FloorConnector;
import walker.blue.path.lib.node.GridNode;

public class FloorSequencer {
    private GridAStar pathfinder;
    private List<List<List<GridNode>>> searchArea;
    private List<FloorConnector> floorConnectors;

    public FloorSequencer(GridAStar pathfinder, List<List<List<GridNode>>> searchArea, List<FloorConnector> floorConnectors) {
        this.pathfinder = pathfinder;
        this.searchArea = searchArea;
        this.floorConnectors = floorConnectors;
    }

    public List<GridNode> findPath(GridNode start, GridNode dest) {
        ArrayList path = null;
        if (start.getLocation().getZ() == dest.getLocation().getZ()) {
            return this.pathfinder.findPath(this.searchArea.get(start.getLocation().getZ()), start, dest);
        }
        List<List<GridNode>> floorSequences = this.findFloorSequences(start.getLocation().getZ(), dest.getLocation().getZ());
        for (int i = 0; i < floorSequences.size(); ++i) {
            if (floorSequences.get(i).size() % 2 != 0) {
                floorSequences.remove(i);
                continue;
            }
            floorSequences.get(i).add(0, start);
            floorSequences.get(i).add(floorSequences.get(i).size(), dest);
        }
        long shortestTime = Long.MAX_VALUE;
        for (int i = 0; i < floorSequences.size(); ++i) {
            long endTime;
            long currentTime;
            boolean hasPath = true;
            ArrayList<GridNode> tempPath = new ArrayList<GridNode>();
            long startTime = System.nanoTime();
            for (int j = 0; j < floorSequences.get(i).size(); j += 2) {
                List<GridNode> path2D = this.pathfinder.findPath(this.searchArea.get(floorSequences.get(i).get(j).getLocation().getZ()), floorSequences.get(i).get(j), floorSequences.get(i).get(j + 1));
                if (path2D == null) {
                    hasPath = false;
                    break;
                }
                tempPath.addAll(path2D);
            }
            if (!hasPath || (currentTime = (endTime = System.nanoTime()) - startTime) >= shortestTime) continue;
            path = new ArrayList(tempPath);
        }
        return path;
    }

    private List<List<GridNode>> findFloorSequences(int startFloor, int destFloor) {
        ArrayList<List<GridNode>> sequences = new ArrayList<List<GridNode>>();
        for (FloorConnector connector : this.floorConnectors) {
            if (connector.getLocation().getZ() != startFloor) continue;
            ArrayList<FloorConnector> sequence = new ArrayList<FloorConnector>();
            ArrayDeque<FloorConnector> stack = new ArrayDeque<FloorConnector>();
            ArrayDeque<Integer> numNeighborsPushedStack = new ArrayDeque<Integer>();
            ArrayDeque<Integer> numPoppedStack = new ArrayDeque<Integer>();
            boolean[] visited = new boolean[this.floorConnectors.size()];
            visited[connector.getIndex()] = true;
            stack.push(connector);
            int numPopped = 0;
            while (!stack.isEmpty()) {
                FloorConnector node = (FloorConnector)stack.pop();
                ++numPopped;
                sequence.add(node);
                if (node.getLocation().getZ() == destFloor) {
                    sequences.add(new ArrayList(sequence));
                    sequence.remove(sequence.size() - 1);
                    visited[node.getIndex()] = false;
                } else {
                    int numNeighborsPushedCount = 0;
                    for (FloorConnector neighbor : node.getConnections()) {
                        if (visited[neighbor.getIndex()]) continue;
                        visited[neighbor.getIndex()] = true;
                        stack.push(neighbor);
                        ++numNeighborsPushedCount;
                    }
                    numNeighborsPushedStack.push(numNeighborsPushedCount);
                    numPoppedStack.push(numPopped);
                    numPopped = 0;
                }
                if (numNeighborsPushedStack.isEmpty() || numPopped != (Integer)numNeighborsPushedStack.peek()) continue;
                FloorConnector removedNode = (FloorConnector)sequence.remove(sequence.size() - 1);
                visited[removedNode.getIndex()] = false;
                numNeighborsPushedStack.pop();
                numPopped = (Integer)numPoppedStack.pop();
            }
        }
        return sequences;
    }

    public void printFloorSequences(List<List<GridNode>> floorSequences) {
        if (floorSequences.isEmpty()) {
            System.out.println("Not possible to go from start floor to destination floor.");
        } else {
            for (int i = 0; i < floorSequences.size(); ++i) {
                System.out.print("Sequence " + i + ": ");
                for (int j = 0; j < floorSequences.get(i).size(); ++j) {
                    System.out.print("(" + floorSequences.get(i).get(j).getLocation().getX() + ", " + floorSequences.get(i).get(j).getLocation().getY() + ", " + floorSequences.get(i).get(j).getLocation().getZ() + ") -> ");
                }
                System.out.println();
            }
        }
    }

    public void printPath(List<List<List<GridNode>>> searchArea, List<GridNode> path) {
        if (path == null) {
            System.out.println("No path.");
        } else {
            int k;
            int j;
            int i;
            char[][][] printedPath = new char[searchArea.size()][searchArea.get(0).size()][searchArea.get(0).get(0).size()];
            for (i = 0; i < searchArea.size(); ++i) {
                for (j = 0; j < searchArea.get(0).size(); ++j) {
                    for (k = 0; k < searchArea.get(0).get(0).size(); ++k) {
                        printedPath[i][j][k] = searchArea.get(i).get(j).get(k) instanceof FloorConnector ? 67 : (searchArea.get(i).get(j).get(k).isTraversable() ? 79 : 88);
                    }
                }
            }
            for (i = 0; i < path.size(); ++i) {
                printedPath[path.get((int)i).getLocation().getZ()][path.get((int)i).getLocation().getY()][path.get((int)i).getLocation().getX()] = i == 0 ? 83 : (i == path.size() - 1 ? 69 : 80);
            }
            for (i = 0; i < printedPath.length; ++i) {
                System.out.println("Floor " + i + ":");
                for (j = 0; j < printedPath[0].length; ++j) {
                    for (k = 0; k < printedPath[0][0].length; ++k) {
                        System.out.print(printedPath[i][j][k]);
                    }
                    System.out.println();
                }
                System.out.println();
                System.out.println();
            }
        }
    }
}

