/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib.floor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import walker.blue.path.lib.node.GridNode;

public class FloorConnector
extends GridNode {
    private int index;
    private Type type;
    private List<FloorConnector> connections;

    public FloorConnector(int x, int y, int z, boolean traversable) {
        this(x, y, z, traversable, new ArrayList<FloorConnector>(), Type.NONE);
    }

    public FloorConnector(int x, int y, int z, boolean traversable, Type type) {
        this(x, y, z, traversable, new ArrayList<FloorConnector>(), type);
    }

    public FloorConnector(int x, int y, int z, boolean traversable, List<FloorConnector> connections) {
        this(x, y, z, traversable, connections, Type.NONE);
    }

    public FloorConnector(int x, int y, int z, boolean traversable, List<FloorConnector> connections, Type type) {
        super(x, y, z, traversable);
        this.connections = connections;
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getTypeString() {
        switch (this.type) {
            case NONE: {
                return "None";
            }
            case STAIRS: {
                return "Stairs";
            }
            case ELEVATOR: {
                return "Elevator";
            }
        }
        return "Unknown";
    }

    public List<FloorConnector> getConnections() {
        return this.connections;
    }

    public boolean addConnection(FloorConnector connection) {
        return this.connections.add(connection);
    }

    public boolean addAllConnections(Collection<? extends FloorConnector> c) {
        return this.connections.addAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.connections.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.connections != null) {
            for (FloorConnector connector : this.connections) {
                buffer.append(connector.getIndex() + " ");
            }
        } else {
            buffer.append("null");
        }
        return super.toString() + "\n" + "Index: " + this.index + "\n" + "Type: " + this.getTypeString() + "\n" + "Connections: " + buffer;
    }

    public static enum Type {
        NONE,
        STAIRS,
        ELEVATOR;

    }
}

