/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib.finder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import walker.blue.path.lib.finder.GridAStar;
import walker.blue.path.lib.node.GridNode;

public class ThetaStar
extends GridAStar {
    @Override
    public List<GridNode> findPath(List<List<GridNode>> searchArea, GridNode start, GridNode dest) {
        HashSet<GridNode> closedSet = new HashSet<GridNode>();
        PriorityQueue<GridNode> openQueue = new PriorityQueue<GridNode>();
        start.setParent(null);
        start.setG(0.0);
        openQueue.add(start);
        while (!openQueue.isEmpty()) {
            GridNode node = (GridNode)openQueue.remove();
            if (node == dest) {
                return this.reconstructPath(start, node);
            }
            closedSet.add(node);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    try {
                        GridNode neighbor = searchArea.get(node.getLocation().getY() + i).get(node.getLocation().getX() + j);
                        if (closedSet.contains(neighbor) || !neighbor.isTraversable()) continue;
                        if (!openQueue.contains(neighbor)) {
                            neighbor.setParent(null);
                            neighbor.setG(Double.POSITIVE_INFINITY);
                            neighbor.setH(this.getManhattanDistance(neighbor, dest));
                        }
                        double oldG = neighbor.getG();
                        this.computeBestPath(searchArea, node, neighbor);
                        if (!(neighbor.getG() < oldG)) continue;
                        if (openQueue.contains(neighbor)) {
                            openQueue.remove(neighbor);
                        }
                        openQueue.add(neighbor);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    protected void computeBestPath(List<List<GridNode>> searchArea, GridNode node, GridNode neighbor) {
        if (node.getParent() != null && this.lineOfSight(searchArea, (GridNode)node.getParent(), neighbor)) {
            int parentNeighborDistance = this.distanceBetweenNodes((GridNode)node.getParent(), neighbor);
            if (node.getParent().getG() + (double)parentNeighborDistance < neighbor.getG()) {
                neighbor.setParent(node.getParent());
                neighbor.setG(node.getParent().getG() + (double)parentNeighborDistance);
            }
        } else {
            int nodeNeighborDistance = this.distanceBetweenNodes(node, neighbor);
            if (node.getG() + (double)nodeNeighborDistance < neighbor.getG()) {
                neighbor.setParent(node);
                neighbor.setG(node.getG() + (double)nodeNeighborDistance);
            }
        }
    }

    private boolean lineOfSight(List<List<GridNode>> searchArea, GridNode a, GridNode b) {
        int xA = a.getLocation().getX();
        int yA = a.getLocation().getY();
        int xB = b.getLocation().getX();
        int yB = b.getLocation().getY();
        int rise = yB - yA;
        int run = xB - xA;
        if (run == 0) {
            if (yB < yA) {
                int temp = yB;
                yB = yA;
                yA = temp;
            }
            for (int y = yA; y < yB + 1; ++y) {
                if (searchArea.get(y).get(xA).isTraversable()) continue;
                return false;
            }
        } else {
            float slope = (float)rise / (float)run;
            int adjust = 1;
            if (slope < 0.0f) {
                adjust = -1;
            }
            int offset = 0;
            if (slope <= 1.0f && slope >= -1.0f) {
                int delta = Math.abs(rise) * 2;
                int threshold = Math.abs(run);
                int thresholdInc = Math.abs(run) * 2;
                int y = yA;
                if (xB < xA) {
                    int temp = xB;
                    xB = xA;
                    xA = temp;
                    y = yB;
                }
                for (int x = xA; x < xB; ++x) {
                    if (!searchArea.get(y).get(x).isTraversable()) {
                        return false;
                    }
                    if ((offset += delta) < threshold) continue;
                    y += adjust;
                    threshold += thresholdInc;
                }
            } else {
                int delta = Math.abs(run) * 2;
                int threshold = Math.abs(rise);
                int thresholdInc = Math.abs(rise) * 2;
                int x = xA;
                if (yB < yA) {
                    int temp = yB;
                    yB = yA;
                    yA = temp;
                    x = xB;
                }
                for (int y = yA; y < yB + 1; ++y) {
                    if (!searchArea.get(y).get(x).isTraversable()) {
                        return false;
                    }
                    if ((offset += delta) < threshold) continue;
                    x += adjust;
                    threshold += thresholdInc;
                }
            }
        }
        return true;
    }

    @Override
    protected int distanceBetweenNodes(GridNode a, GridNode b) {
        int xDelta = b.getLocation().getX() - a.getLocation().getX();
        int yDelta = b.getLocation().getY() - a.getLocation().getY();
        if (xDelta < 0) {
            xDelta = -xDelta;
        }
        if (yDelta < 0) {
            yDelta = -yDelta;
        }
        return (int)(10.0 * Math.sqrt(xDelta + yDelta));
    }

    public void printAllLOSNodeCombinations(List<List<GridNode>> searchArea) {
        int count = 0;
        for (int i = 0; i < searchArea.size(); ++i) {
            for (int j = 0; j < searchArea.get(0).size(); ++j) {
                for (int k = 0; k < searchArea.size(); ++k) {
                    for (int w = 0; w < searchArea.get(0).size(); ++w) {
                        System.out.print(count + ": " + "1st: (" + searchArea.get(i).get(j).getLocation().getX() + ", " + searchArea.get(i).get(j).getLocation().getY() + "), 2nd: (" + searchArea.get(k).get(w).getLocation().getX() + ", " + searchArea.get(k).get(w).getLocation().getY() + ") ");
                        System.out.println(this.lineOfSight(searchArea, searchArea.get(i).get(j), searchArea.get(k).get(w)));
                        ++count;
                    }
                }
            }
        }
    }

    public List<List<String>> getVisibilityGraph(List<List<GridNode>> searchArea, GridNode node) {
        int i;
        ArrayList<List<String>> visibilityGraph = new ArrayList<List<String>>();
        for (i = 0; i < searchArea.size(); ++i) {
            visibilityGraph.add(new ArrayList());
        }
        for (i = 0; i < searchArea.size(); ++i) {
            for (int j = 0; j < searchArea.get(0).size(); ++j) {
                if (i == node.getLocation().getY() && j == node.getLocation().getX()) {
                    ((List)visibilityGraph.get(i)).add(j, "S");
                    continue;
                }
                if (!searchArea.get(i).get(j).isTraversable()) {
                    ((List)visibilityGraph.get(i)).add(j, "X");
                    continue;
                }
                if (this.lineOfSight(searchArea, node, searchArea.get(i).get(j))) {
                    ((List)visibilityGraph.get(i)).add(j, "V");
                    continue;
                }
                ((List)visibilityGraph.get(i)).add(j, " ");
            }
        }
        return visibilityGraph;
    }
}

