/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib.finder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import walker.blue.path.lib.base.AbstractPathfinder;
import walker.blue.path.lib.node.GridNode;

public class GridAStar
extends AbstractPathfinder<GridNode, List<List<GridNode>>> {
    @Override
    public List<GridNode> findPath(List<List<GridNode>> searchArea, GridNode start, GridNode dest) {
        HashSet<GridNode> closedSet = new HashSet<GridNode>();
        PriorityQueue<GridNode> openQueue = new PriorityQueue<GridNode>();
        start.setParent(null);
        start.setG(0.0);
        openQueue.add(start);
        while (!openQueue.isEmpty()) {
            GridNode node = (GridNode)openQueue.remove();
            if (node == dest) {
                return this.reconstructPath(start, node);
            }
            closedSet.add(node);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    try {
                        GridNode neighbor = searchArea.get(node.getLocation().getY() + i).get(node.getLocation().getX() + j);
                        if (closedSet.contains(neighbor) || !neighbor.isTraversable()) continue;
                        if (!openQueue.contains(neighbor)) {
                            neighbor.setParent(null);
                            neighbor.setG(Double.POSITIVE_INFINITY);
                            neighbor.setH(this.getManhattanDistance(neighbor, dest));
                        }
                        double oldG = neighbor.getG();
                        this.computeBestPath(node, neighbor);
                        if (!(neighbor.getG() < oldG)) continue;
                        if (openQueue.contains(neighbor)) {
                            openQueue.remove(neighbor);
                        }
                        openQueue.add(neighbor);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    protected void computeBestPath(GridNode node, GridNode neighbor) {
        int nodeNeighborDistance = this.distanceBetweenNodes(node, neighbor);
        if (node.getG() + (double)nodeNeighborDistance < neighbor.getG()) {
            neighbor.setParent(node);
            neighbor.setG(node.getG() + (double)nodeNeighborDistance);
        }
    }

    protected int distanceBetweenNodes(GridNode a, GridNode b) {
        if (a.getLocation().getX() != b.getLocation().getX() && a.getLocation().getY() != b.getLocation().getY()) {
            return 14;
        }
        return 10;
    }

    protected int getManhattanDistance(GridNode a, GridNode b) {
        int xDelta = b.getLocation().getX() - a.getLocation().getX();
        int yDelta = b.getLocation().getY() - a.getLocation().getY();
        if (xDelta < 0) {
            xDelta = -xDelta;
        }
        if (yDelta < 0) {
            yDelta = -yDelta;
        }
        return 10 * (xDelta + yDelta);
    }

    protected List<GridNode> reconstructPath(GridNode start, GridNode dest) {
        ArrayList<GridNode> path = new ArrayList<GridNode>();
        GridNode node = dest;
        while (true) {
            path.add(0, node);
            if (node == start) break;
            node = (GridNode)node.getParent();
        }
        return path;
    }

    public void printSearchArea(List<List<GridNode>> searchArea) {
        for (int i = 0; i < searchArea.size(); ++i) {
            for (int j = 0; j < searchArea.get(0).size(); ++j) {
                if (searchArea.get(i).get(j).isTraversable()) {
                    System.out.print('O');
                    continue;
                }
                System.out.print('X');
            }
            System.out.println();
        }
    }

    public void printPath(List<List<GridNode>> searchArea, List<GridNode> path) {
        if (path == null) {
            System.out.println("No path.");
        } else {
            int j;
            int i;
            char[][] printedPath = new char[searchArea.size()][searchArea.get(0).size()];
            for (i = 0; i < searchArea.size(); ++i) {
                for (j = 0; j < searchArea.get(0).size(); ++j) {
                    printedPath[i][j] = searchArea.get(i).get(j).isTraversable() ? 79 : 88;
                }
            }
            for (i = 0; i < path.size(); ++i) {
                printedPath[path.get((int)i).getLocation().getY()][path.get((int)i).getLocation().getX()] = i == 0 ? 83 : (i == path.size() - 1 ? 69 : 80);
            }
            for (i = 0; i < printedPath.length; ++i) {
                for (j = 0; j < printedPath[0].length; ++j) {
                    System.out.print(printedPath[i][j]);
                }
                System.out.println();
            }
        }
    }
}

