/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib;

import walker.blue.path.lib.RectCoordinates;

public class NodeMapper {
    private double nodeDistance;
    private double floorHeight;

    public NodeMapper(double nodeDistance, double floorHeight) {
        this.nodeDistance = nodeDistance;
        this.floorHeight = floorHeight;
    }

    public RectCoordinates getGridLocation(RectCoordinates realLoc) {
        int xIndex = (int)((double)realLoc.y() / this.nodeDistance);
        int yIndex = (int)((double)realLoc.x() / this.nodeDistance);
        int zIndex = (int)((double)realLoc.z() / this.floorHeight);
        return new RectCoordinates(xIndex, yIndex, zIndex);
    }

    public RectCoordinates getRealLocation(RectCoordinates gridLocation) {
        int xLoc = (int)((double)gridLocation.x() * this.nodeDistance);
        int yLoc = (int)((double)gridLocation.y() * this.nodeDistance);
        int zLoc = (int)((double)gridLocation.z() * this.floorHeight);
        return new RectCoordinates(xLoc, yLoc, zLoc);
    }

    public double getNodeDistance() {
        return this.nodeDistance;
    }

    public double getFloorHeight() {
        return this.floorHeight;
    }
}

