/*
 * Decompiled with CFR 0.152.
 */
package walker.blue.path.lib;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import walker.blue.path.lib.FloorConnectorNode;
import walker.blue.path.lib.GridAStar;
import walker.blue.path.lib.GridNode;
import walker.blue.path.lib.RectCoordinates;

public class FloorSequencer {
    private GridAStar pathfinder;
    private List<List<List<GridNode>>> searchArea;
    private int numConnectorNodes;

    public FloorSequencer(GridAStar pathfinder, List<List<List<GridNode>>> searchArea) {
        this.pathfinder = pathfinder;
        this.searchArea = searchArea;
        for (int i = 0; i < searchArea.size(); ++i) {
            for (int j = 0; j < searchArea.get(i).size(); ++j) {
                for (int k = 0; k < searchArea.get(i).get(j).size(); ++k) {
                    GridNode gridNode = searchArea.get(i).get(j).get(k);
                    if (!(gridNode instanceof FloorConnectorNode)) continue;
                    ++this.numConnectorNodes;
                }
            }
        }
    }

    public List<GridNode> findPath(GridNode start, GridNode dest) {
        ArrayList path = null;
        if (start.location().z() == dest.location().z()) {
            return this.pathfinder.findPath(this.searchArea.get(start.location().z()), start, dest);
        }
        List<List<GridNode>> floorSequences = this.findFloorSequences(start.location().z(), dest.location().z());
        for (int i = 0; i < floorSequences.size(); ++i) {
            if (floorSequences.get(i).size() % 2 != 0) {
                floorSequences.remove(i);
                continue;
            }
            floorSequences.get(i).add(0, start);
            floorSequences.get(i).add(floorSequences.get(i).size(), dest);
        }
        long shortestTime = Long.MAX_VALUE;
        for (int i = 0; i < floorSequences.size(); ++i) {
            long endTime;
            long currentTime;
            boolean hasPath = true;
            ArrayList<GridNode> tempPath = new ArrayList<GridNode>();
            long startTime = System.nanoTime();
            for (int j = 0; j < floorSequences.get(i).size(); j += 2) {
                List<GridNode> path2D = this.pathfinder.findPath(this.searchArea.get(floorSequences.get(i).get(j).location().z()), floorSequences.get(i).get(j), floorSequences.get(i).get(j + 1));
                if (path2D == null) {
                    hasPath = false;
                    break;
                }
                tempPath.addAll(path2D);
            }
            if (!hasPath || (currentTime = (endTime = System.nanoTime()) - startTime) >= shortestTime) continue;
            path = new ArrayList(tempPath);
        }
        return path;
    }

    private List<List<GridNode>> findFloorSequences(int startFloor, int destFloor) {
        ArrayList<List<GridNode>> sequences = new ArrayList<List<GridNode>>();
        for (int i = 0; i < this.searchArea.get(startFloor).size(); ++i) {
            for (int j = 0; j < this.searchArea.get(startFloor).get(i).size(); ++j) {
                GridNode gridNode = this.searchArea.get(startFloor).get(i).get(j);
                if (!(gridNode instanceof FloorConnectorNode)) continue;
                ArrayList<GridNode> sequence = new ArrayList<GridNode>();
                ArrayDeque<FloorConnectorNode> stack = new ArrayDeque<FloorConnectorNode>();
                ArrayDeque<Integer> numNeighborsPushedStack = new ArrayDeque<Integer>();
                ArrayDeque<Integer> numPoppedStack = new ArrayDeque<Integer>();
                boolean[] visited = new boolean[this.numConnectorNodes];
                FloorConnectorNode connectorNode = (FloorConnectorNode)gridNode;
                visited[connectorNode.index()] = true;
                stack.push(connectorNode);
                int numPopped = 0;
                while (!stack.isEmpty()) {
                    FloorConnectorNode node = (FloorConnectorNode)stack.pop();
                    ++numPopped;
                    sequence.add(this.searchArea.get(node.location().z()).get(node.location().y()).get(node.location().x()));
                    if (node.location().z() == destFloor) {
                        sequences.add(new ArrayList(sequence));
                        sequence.remove(sequence.size() - 1);
                        visited[node.index()] = false;
                    } else {
                        int numNeighborsPushedCount = 0;
                        for (int n = 0; n < node.connections().size(); ++n) {
                            RectCoordinates neighborLoc = node.connections().get(n);
                            FloorConnectorNode neighbor = (FloorConnectorNode)this.searchArea.get(neighborLoc.z()).get(neighborLoc.y()).get(neighborLoc.x());
                            if (visited[neighbor.index()]) continue;
                            visited[neighbor.index()] = true;
                            stack.push(neighbor);
                            ++numNeighborsPushedCount;
                        }
                        numNeighborsPushedStack.push(numNeighborsPushedCount);
                        numPoppedStack.push(numPopped);
                        numPopped = 0;
                    }
                    if (numNeighborsPushedStack.isEmpty() || numPopped != (Integer)numNeighborsPushedStack.peek()) continue;
                    FloorConnectorNode removedNode = (FloorConnectorNode)sequence.remove(sequence.size() - 1);
                    visited[removedNode.index()] = false;
                    numNeighborsPushedStack.pop();
                    numPopped = (Integer)numPoppedStack.pop();
                }
            }
        }
        return sequences;
    }

    public void printFloorSequences(List<List<GridNode>> floorSequences) {
        if (floorSequences.isEmpty()) {
            System.out.println("Not possible to go from start floor to destination floor.");
        } else {
            for (int i = 0; i < floorSequences.size(); ++i) {
                System.out.print("Sequence " + i + ": ");
                for (int j = 0; j < floorSequences.get(i).size(); ++j) {
                    System.out.print("(" + floorSequences.get(i).get(j).location().x() + ", " + floorSequences.get(i).get(j).location().y() + ", " + floorSequences.get(i).get(j).location().z() + ") -> ");
                }
                System.out.println();
            }
        }
    }

    public void printPath(List<List<List<GridNode>>> searchArea, List<GridNode> path) {
        if (path == null) {
            System.out.println("No path.");
        } else {
            int k;
            int j;
            int i;
            char[][][] printedPath = new char[searchArea.size()][searchArea.get(0).size()][searchArea.get(0).get(0).size()];
            for (i = 0; i < searchArea.size(); ++i) {
                for (j = 0; j < searchArea.get(0).size(); ++j) {
                    for (k = 0; k < searchArea.get(0).get(0).size(); ++k) {
                        printedPath[i][j][k] = searchArea.get(i).get(j).get(k) instanceof FloorConnectorNode ? 67 : (searchArea.get(i).get(j).get(k).walkable() ? 79 : 88);
                    }
                }
            }
            for (i = 0; i < path.size(); ++i) {
                printedPath[path.get((int)i).location().z()][path.get((int)i).location().y()][path.get((int)i).location().x()] = i == 0 ? 83 : (i == path.size() - 1 ? 69 : 80);
            }
            for (i = 0; i < printedPath.length; ++i) {
                System.out.println("Floor " + i + ":");
                for (j = 0; j < printedPath[0].length; ++j) {
                    for (k = 0; k < printedPath[0][0].length; ++k) {
                        System.out.print(printedPath[i][j][k]);
                    }
                    System.out.println();
                }
                System.out.println();
                System.out.println();
            }
        }
    }
}

