/*
 * Decompiled with CFR 0.152.
 */
package biz.massivedynamics.versioneer.version.impl;

import biz.massivedynamics.versioneer.version.Version;
import biz.massivedynamics.versioneer.version.VersionType;
import biz.massivedynamics.versioneer.version.impl.FourPartVersion;

public final class TwoPartVersion
extends Version {
    private int major;
    private int minor;

    public TwoPartVersion(int major) {
        this(major, 0);
    }

    public TwoPartVersion(int major, int minor) {
        this(major, minor, VersionType.STABLE);
    }

    public TwoPartVersion(int major, int minor, VersionType type) {
        this(major, minor, type, "");
    }

    public TwoPartVersion(int major, int minor, VersionType type, String codeName) {
        super(type, codeName);
        this.setMajor(major);
        this.setMinor(minor);
    }

    public final int getMajor() {
        return this.major;
    }

    public final void setMajor(int major) {
        if (major < 0) {
            major = 0;
        }
        this.major = major;
    }

    public final int getMinor() {
        if (this.minor < 0) {
            this.minor = 0;
        }
        return this.minor;
    }

    public final void setMinor(int minor) {
        this.minor = minor;
    }

    @Override
    public FourPartVersion toFourPartVersion() {
        return new FourPartVersion(this.getMajor(), this.getMinor(), 0, 0, this.getType(), this.getCodeName());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor).append(this.getType().getPostfix());
        if (!this.getCodeName().isEmpty()) {
            builder.append(" '").append(this.getCodeName()).append("'");
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Version t) {
        if (!(t instanceof TwoPartVersion)) {
            return this.toFourPartVersion().compareTo(t.toFourPartVersion());
        }
        TwoPartVersion other = (TwoPartVersion)t;
        if (other.getMajor() > this.getMajor()) {
            return -1;
        }
        if (other.getMajor() < this.getMajor()) {
            return 1;
        }
        if (other.getMinor() > this.getMinor()) {
            return -1;
        }
        if (other.getMinor() < this.getMinor()) {
            return 1;
        }
        return this.getType().compareTo(other.getType());
    }

    @Override
    public TwoPartVersion clone() {
        return new TwoPartVersion(this.getMajor(), this.getMinor(), this.getType(), this.getCodeName());
    }

    @Override
    public int hashCode() {
        return this.getMajor() << 8 + this.getMinor() << 4 + this.getType().hashCode();
    }
}

