/*
 * Decompiled with CFR 0.152.
 */
package biz.massivedynamics.versioneer.version.impl;

import biz.massivedynamics.versioneer.version.Version;
import biz.massivedynamics.versioneer.version.VersionType;
import biz.massivedynamics.versioneer.version.impl.FourPartVersion;

public final class ThreePartVersion
extends Version {
    private int major;
    private int minor;
    private int build;

    public ThreePartVersion(int major) {
        this(major, 0);
    }

    public ThreePartVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public ThreePartVersion(int major, int minor, int build) {
        this(major, minor, build, VersionType.STABLE);
    }

    public ThreePartVersion(int major, int minor, int build, VersionType type) {
        this(major, minor, build, type, "");
    }

    public ThreePartVersion(int major, int minor, int build, VersionType type, String codeName) {
        super(type, codeName);
        this.setMajor(major);
        this.setMinor(minor);
        this.setBuild(build);
    }

    public final int getMajor() {
        return this.major;
    }

    public final void setMajor(int major) {
        if (major < 0) {
            major = 0;
        }
        this.major = major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final void setMinor(int minor) {
        if (minor < 0) {
            minor = 0;
        }
        this.minor = minor;
    }

    public final int getBuild() {
        return this.build;
    }

    public final void setBuild(int build) {
        if (build < 0) {
            build = 0;
        }
        this.build = build;
    }

    @Override
    public FourPartVersion toFourPartVersion() {
        return new FourPartVersion(this.getMajor(), this.getMinor(), this.getBuild(), 0, this.getType(), this.getCodeName());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor).append('.').append(this.build).append(this.getType().getPostfix());
        if (!this.getCodeName().isEmpty()) {
            builder.append(" '").append(this.getCodeName()).append("'");
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Version t) {
        if (!(t instanceof ThreePartVersion)) {
            return this.toFourPartVersion().compareTo(t.toFourPartVersion());
        }
        ThreePartVersion other = (ThreePartVersion)t;
        if (other.getMajor() > this.getMajor()) {
            return -1;
        }
        if (other.getMajor() < this.getMajor()) {
            return 1;
        }
        if (other.getMinor() > this.getMinor()) {
            return -1;
        }
        if (other.getMinor() < this.getMinor()) {
            return 1;
        }
        if (other.getBuild() > this.getBuild()) {
            return -1;
        }
        if (other.getBuild() < this.getBuild()) {
            return 1;
        }
        return this.getType().compareTo(other.getType());
    }

    @Override
    public ThreePartVersion clone() {
        return new ThreePartVersion(this.getMajor(), this.getMinor(), this.getBuild(), this.getType(), this.getCodeName());
    }

    @Override
    public int hashCode() {
        return this.getMajor() << 12 + this.getMinor() << 8 + this.getBuild() << 4 + this.getType().hashCode();
    }
}

