/*
 * Decompiled with CFR 0.152.
 */
package biz.massivedynamics.versioneer.version.impl;

import biz.massivedynamics.versioneer.version.Version;
import biz.massivedynamics.versioneer.version.VersionType;
import biz.massivedynamics.versioneer.version.impl.FourPartVersion;

public final class NumericVersion
extends Version {
    private int version;

    public NumericVersion(int version) {
        this(version, VersionType.STABLE);
    }

    public NumericVersion(int version, VersionType type) {
        this(version, type, "");
    }

    public NumericVersion(int version, VersionType type, String codeName) {
        super(type, codeName);
        this.setVersion(version);
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int version) {
        if (version < 0) {
            version = 0;
        }
        this.version = version;
    }

    @Override
    public FourPartVersion toFourPartVersion() {
        return new FourPartVersion(this.getVersion(), 0, 0, 0, this.getType(), this.getCodeName());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getVersion()).append(this.getType().getPostfix());
        if (!this.getCodeName().isEmpty()) {
            builder.append(" '").append(this.getCodeName()).append("'");
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Version t) {
        if (!(t instanceof NumericVersion)) {
            return this.toFourPartVersion().compareTo(t.toFourPartVersion());
        }
        NumericVersion other = (NumericVersion)t;
        if (this.getVersion() > other.getVersion()) {
            return 1;
        }
        if (this.getVersion() < other.getVersion()) {
            return -1;
        }
        return this.getType().compareTo(other.getType());
    }

    @Override
    public NumericVersion clone() {
        return new NumericVersion(this.getVersion(), this.getType(), this.getCodeName());
    }

    @Override
    public int hashCode() {
        return this.getVersion() << 4 + this.getType().hashCode();
    }
}

