/*
 * Decompiled with CFR 0.152.
 */
package biz.massivedynamics.versioneer.version;

import biz.massivedynamics.versioneer.version.InvalidVersionException;
import biz.massivedynamics.versioneer.version.VersionType;
import biz.massivedynamics.versioneer.version.impl.FourPartVersion;
import biz.massivedynamics.versioneer.version.impl.NumericVersion;
import biz.massivedynamics.versioneer.version.impl.ThreePartVersion;
import biz.massivedynamics.versioneer.version.impl.TwoPartVersion;

public abstract class Version
implements Comparable<Version>,
Cloneable {
    private VersionType type;
    private String codeName;

    public Version(VersionType type, String codeName) {
        this.setType(type);
        this.setCodeName(codeName);
    }

    public final VersionType getType() {
        return this.type;
    }

    public final void setType(VersionType type) {
        this.type = type;
    }

    public final String getCodeName() {
        return this.codeName;
    }

    public final void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public abstract FourPartVersion toFourPartVersion();

    public abstract String toString();

    public final boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        FourPartVersion version = ((Version)obj).toFourPartVersion();
        return this.compareTo(version) == 0;
    }

    public abstract int hashCode();

    public abstract Version clone();

    public static Version get(String versionAsString) throws InvalidVersionException, IllegalArgumentException {
        Version version = null;
        if (versionAsString.isEmpty()) {
            throw new InvalidVersionException("Can't create a blank version!");
        }
        String[] versionParts = versionAsString.split("\\.");
        switch (versionParts.length) {
            case 4: {
                int major = Integer.valueOf(versionParts[0]);
                int minor = Integer.valueOf(versionParts[1]);
                int build = Integer.valueOf(versionParts[2]);
                int revision = versionParts[3].contains("-") || versionParts[3].contains(" ") ? Integer.valueOf(versionParts[3].split("[ -]")[0]).intValue() : Integer.valueOf(versionParts[3]).intValue();
                version = new FourPartVersion(major, minor, build, revision);
                break;
            }
            case 3: {
                int major = Integer.valueOf(versionParts[0]);
                int minor = Integer.valueOf(versionParts[1]);
                int build = versionParts[2].contains("-") || versionParts[2].contains(" ") ? Integer.valueOf(versionParts[2].split("[ -]")[0]).intValue() : Integer.valueOf(versionParts[2]).intValue();
                version = new ThreePartVersion(major, minor, build);
                break;
            }
            case 2: {
                int major = Integer.valueOf(versionParts[0]);
                int minor = versionParts[1].contains("-") || versionParts[1].contains(" ") ? Integer.valueOf(versionParts[1].split("[ -]")[0]).intValue() : Integer.valueOf(versionParts[1]).intValue();
                version = new TwoPartVersion(major, minor);
                break;
            }
            case 1: {
                int _version = versionParts[0].contains("-") || versionParts[0].contains(" ") ? Integer.valueOf(versionParts[0].split("[ -]")[0]).intValue() : Integer.valueOf(versionParts[0]).intValue();
                version = new NumericVersion(_version);
            }
        }
        if (version == null) {
            throw new InvalidVersionException("Version \"" + versionAsString + "\" could not be decoded");
        }
        String lastPart = versionParts[versionParts.length - 1];
        if (lastPart.contains("-")) {
            String versionTypeString = lastPart.contains(" ") ? lastPart.substring(lastPart.indexOf("-") + 1, lastPart.indexOf(" ")) : lastPart.substring(lastPart.indexOf("-") + 1, lastPart.length());
            if (versionTypeString.equalsIgnoreCase("RC")) {
                version.setType(VersionType.RELEASE_CANDIDATE);
            } else {
                version.setType(VersionType.valueOf(versionTypeString));
            }
        }
        if (lastPart.contains(" ")) {
            if (lastPart.contains("'")) {
                version.setCodeName(lastPart.substring(lastPart.indexOf("'") + 1, lastPart.lastIndexOf("'")));
            } else if (lastPart.contains("\"")) {
                version.setCodeName(lastPart.substring(lastPart.indexOf("\"") + 1, lastPart.lastIndexOf("\"")));
            }
        }
        return version;
    }
}

