/*
 * Decompiled with CFR 0.152.
 */
package biz.massivedynamics.versioneer.version.impl;

import biz.massivedynamics.versioneer.version.Version;
import biz.massivedynamics.versioneer.version.VersionType;

public class GenericVersion
extends Version {
    private int major;
    private int minor;
    private int build;
    private int revision;

    public GenericVersion(int major) {
        this(major, 0, 0, 0, VersionType.STABLE, "");
    }

    public GenericVersion(int major, int minor) {
        this(major, minor, 0, 0, VersionType.STABLE, "");
    }

    public GenericVersion(int major, int minor, int build) {
        this(major, minor, build, 0, VersionType.STABLE, "");
    }

    public GenericVersion(int major, int minor, int build, int revision) {
        this(major, minor, build, revision, VersionType.STABLE, "");
    }

    public GenericVersion(int major, int minor, int build, int revision, VersionType type) {
        this(major, minor, build, revision, type, "");
    }

    public GenericVersion(int major, int minor, int build, int revision, VersionType type, String codeName) {
        super(type, codeName);
        this.setMajor(major);
        this.setMinor(minor);
        this.setBuild(build);
        this.setRevision(revision);
    }

    public final int getMajor() {
        return this.major;
    }

    public final void setMajor(int major) {
        if (major < 0) {
            major = 0;
        }
        this.major = major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final void setMinor(int minor) {
        if (minor < 0) {
            minor = 0;
        }
        this.minor = minor;
    }

    public final int getBuild() {
        return this.build;
    }

    public final void setBuild(int build) {
        if (build < 0) {
            build = 0;
        }
        this.build = build;
    }

    public final int getRevision() {
        return this.revision;
    }

    public final void setRevision(int revision) {
        if (revision < 0) {
            revision = 0;
        }
        this.revision = revision;
    }

    @Override
    public int compareTo(Version t) {
        GenericVersion other;
        if (!(t instanceof GenericVersion)) {
            this.compareTo(t.toGenericVersion());
        }
        if ((other = (GenericVersion)t).getMajor() > this.getMajor()) {
            return -1;
        }
        if (other.getMajor() < this.getMajor()) {
            return 1;
        }
        if (other.getMinor() > this.getMinor()) {
            return -1;
        }
        if (other.getMinor() < this.getMinor()) {
            return 1;
        }
        if (other.getBuild() > this.getBuild()) {
            return -1;
        }
        if (other.getBuild() < this.getBuild()) {
            return 1;
        }
        if (other.getRevision() > this.getRevision()) {
            return -1;
        }
        if (other.getRevision() < this.getRevision()) {
            return 1;
        }
        return this.getType().compareTo(other.getType());
    }

    @Override
    public GenericVersion toGenericVersion() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor).append('.').append(this.build).append('.').append(this.revision).append(this.getType().getPostfix());
        if (!this.getCodeName().isEmpty()) {
            builder.append(" '").append(this.getCodeName()).append("'");
        }
        return builder.toString();
    }

    @Override
    public GenericVersion clone() {
        return new GenericVersion(this.getMajor(), this.getMinor(), this.getBuild(), this.getRevision(), this.getType(), this.getCodeName());
    }

    @Override
    public int hashCode() {
        return this.getMajor() << 16 + this.getMinor() << 12 + this.getBuild() << 8 + this.getRevision() << 4 + this.getType().hashCode();
    }
}

