/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.rng;

import biz.k11i.util.MathFunctions;
import java.util.Random;

public interface GaussianRNG {
    public static final GaussianRNG FAST_RNG = ZigguratFast.access$000();
    public static final GaussianRNG GENERAL_RNG = ZigguratGeneral.access$100();

    public double generate(Random var1);

    public static class ZigguratGeneral
    extends ZigguratBase
    implements GaussianRNG {
        private static final ZigguratGeneral Z_256 = new ZigguratGeneral(8, 3.654152885361009, 0.00492867323399);
        private final int N;
        private final double R;
        private final double V;
        private final int INDEX_BIT_MASK;
        private final int TAIL_INDEX;
        private final double[] x;
        private final double[] xx;
        private final double[] t;

        ZigguratGeneral(int nBits, double r, double v) {
            int i;
            this.N = 1 << nBits;
            this.R = r;
            this.V = v;
            this.INDEX_BIT_MASK = this.N - 1;
            this.TAIL_INDEX = this.N - 1;
            this.x = new double[this.N + 1];
            this.xx = new double[this.N + 1];
            this.t = new double[this.N];
            this.x[this.N] = v * MathFunctions.exp(0.5 * r * r);
            this.x[this.N - 1] = r;
            for (i = this.N - 2; i >= 1; --i) {
                this.x[i] = Math.sqrt(-2.0 * MathFunctions.log(ZigguratGeneral.f(this.x[i + 1]) + v / this.x[i + 1]));
            }
            this.x[0] = 0.0;
            for (i = 0; i < this.t.length; ++i) {
                this.t[i] = this.x[i] / this.x[i + 1];
            }
            for (i = 0; i < this.x.length; ++i) {
                this.xx[i] = this.x[i] * this.x[i];
            }
        }

        @Override
        public double generate(Random random) {
            double y;
            double gL;
            double gU;
            do {
                int i = random.nextInt() & this.INDEX_BIT_MASK;
                double u1 = 2.0 * random.nextDouble() - 1.0;
                if (Math.abs(u1) < this.t[i]) {
                    return u1 * this.x[i + 1];
                }
                if (i == this.TAIL_INDEX) {
                    return Math.signum(u1) * ZigguratGeneral.tail(random, this.R);
                }
                y = u1 * this.x[i + 1];
                double yy = y * y;
                gU = MathFunctions.exp(-0.5 * (this.xx[i] - yy));
                gL = MathFunctions.exp(-0.5 * (this.xx[i + 1] - yy));
            } while (!(random.nextDouble() * (gU - gL) <= 1.0 - gL));
            return y;
        }

        public String toString() {
            return String.format("ZigguratGeneral(N = %d, R = %f, V = %f)", this.N, this.R, this.V);
        }

        static /* synthetic */ ZigguratGeneral access$100() {
            return Z_256;
        }
    }

    public static class ZigguratFast
    extends ZigguratBase
    implements GaussianRNG {
        private static final ZigguratFast Z_256 = new ZigguratFast(8, 3.654152885361009, 0.00492867323399);
        private final int N;
        private final double R;
        private final double V;
        private final int INDEX_RIGHT_SHIFT_BITS;
        private final long SIGN_BIT_MASK;
        private final long U_BIT_MASK;
        private final int TAIL_INDEX;
        private final long[] k;
        private final double[] w;
        private final double[] f;

        ZigguratFast(int nBits, double r, double v) {
            this.N = 1 << nBits;
            this.R = r;
            this.V = v;
            this.INDEX_RIGHT_SHIFT_BITS = 64 - nBits;
            this.SIGN_BIT_MASK = 1L << 64 - nBits - 1;
            this.U_BIT_MASK = (1L << 64 - nBits - 1) - 1L;
            this.TAIL_INDEX = this.N - 1;
            this.k = new long[this.N];
            this.w = new double[this.N];
            this.f = new double[this.N];
            double fr = ZigguratFast.f(r);
            long b = 0x80000000000000L;
            this.w[this.N - 1] = v * MathFunctions.exp(0.5 * r * r) / (double)b;
            this.w[this.N - 2] = r / (double)b;
            this.k[this.N - 1] = (long)Math.floor(r / this.w[this.N - 1]);
            this.f[this.N - 1] = fr;
            double x = r;
            for (int i = this.N - 2; i >= 1; --i) {
                x = Math.sqrt(-2.0 * MathFunctions.log(ZigguratFast.f(x) + v / x));
                this.w[i - 1] = x / (double)b;
                this.k[i] = (long)Math.floor(x / this.w[i]);
                this.f[i] = ZigguratFast.f(x);
            }
            this.k[0] = 0L;
            this.f[0] = 1.0;
        }

        @Override
        public double generate(Random random) {
            int sign;
            double x;
            int i;
            do {
                long u = random.nextLong();
                i = (int)(u >>> this.INDEX_RIGHT_SHIFT_BITS);
                int n = sign = (u & this.SIGN_BIT_MASK) == 0L ? 1 : -1;
                if ((u &= this.U_BIT_MASK) < this.k[i]) {
                    return (double)((long)sign * u) * this.w[i];
                }
                if (i == this.TAIL_INDEX) {
                    return (double)sign * ZigguratFast.tail(random, this.R);
                }
                x = (double)u * this.w[i];
            } while (!(random.nextDouble() * (this.f[i] - this.f[i + 1]) <= ZigguratFast.f(x) - this.f[i + 1]));
            return (double)sign * x;
        }

        public String toString() {
            return String.format("ZigguratFast(N = %d, R = %f, V = %f)", this.N, this.R, this.V);
        }

        static /* synthetic */ ZigguratFast access$000() {
            return Z_256;
        }
    }

    public static abstract class ZigguratBase {
        static double f(double x) {
            return MathFunctions.exp(-0.5 * x * x);
        }

        static double tail(Random random, double r) {
            double _x;
            double _y;
            do {
                _x = -MathFunctions.log(random.nextDouble()) / r;
            } while ((_y = -MathFunctions.log(random.nextDouble())) + _y < _x * _x);
            return r + _x;
        }
    }
}

