/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.rng;

import biz.k11i.rng.ExponentialRNG;
import biz.k11i.rng.GammaRNG;
import biz.k11i.rng.GaussianRNG;
import biz.k11i.util.MathFunctions;
import java.util.Random;

class GammaRNGAlgorithms {
    GammaRNGAlgorithms() {
    }

    static class WilsonHilfertyApproximation
    extends BaseGammaRNG {
        private final GaussianRNG gaussianRNG;

        WilsonHilfertyApproximation(GaussianRNG gaussianRNG) {
            this.gaussianRNG = gaussianRNG;
        }

        @Override
        double generate(Random random, double shape) {
            double t;
            double t0 = 1.0 / (9.0 * shape);
            double t1 = 1.0 - t0;
            double t2 = Math.sqrt(t0);
            while ((t = t1 + t2 * this.gaussianRNG.generate(random)) <= 0.0) {
            }
            return shape * t * t * t;
        }

        @Override
        public String toString() {
            return String.format("WilsonHilfertyApproximation[%s]", this.gaussianRNG.getClass().getSimpleName());
        }
    }

    static class MarsagliaTsang
    extends BaseGammaRNG {
        private final GaussianRNG gaussianRNG;

        MarsagliaTsang(GaussianRNG gaussianRNG) {
            this.gaussianRNG = gaussianRNG;
        }

        @Override
        double generate(Random random, double shape) {
            if (shape >= 1.0) {
                return this.generateMT(random, shape);
            }
            double r = this.generateMT(random, shape + 1.0);
            double u = random.nextDouble();
            if (shape != 0.5) {
                return r * MathFunctions.pow(u, 1.0 / shape);
            }
            return r * u * u;
        }

        double generateMT(Random random, double shape) {
            double v;
            double d = shape - 0.3333333333333333;
            double c = 1.0 / Math.sqrt(9.0 * d);
            while (true) {
                double x;
                if ((v = 1.0 + c * (x = this.gaussianRNG.generate(random))) <= 0.0) {
                    continue;
                }
                v = v * v * v;
                x *= x;
                double u = random.nextDouble();
                if (u < 1.0 - 0.0331 * x * x) {
                    return d * v;
                }
                if (MathFunctions.log(u) < 0.5 * x + d * (1.0 - v + MathFunctions.log(v))) break;
            }
            return d * v;
        }

        @Override
        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this.gaussianRNG.getClass().getSimpleName());
        }
    }

    static class Exponential
    implements GammaRNG {
        private final ExponentialRNG exponentialRNG;

        Exponential(ExponentialRNG exponentialRNG) {
            this.exponentialRNG = exponentialRNG;
        }

        @Override
        public double generate(Random random, double shape, double scale) {
            return this.exponentialRNG.generate(random, 1.0) * scale;
        }

        public String toString() {
            return String.format("Exponential[%s]", this.exponentialRNG.getClass().getSimpleName());
        }
    }

    static class Best
    extends BaseGammaRNG {
        Best() {
        }

        @Override
        double generate(Random random, double shape) {
            double y;
            double x;
            double u2;
            double u1;
            double v;
            double c1 = 0.07 + 0.75 * Math.sqrt(1.0 - shape);
            double c2 = 1.0 + shape * MathFunctions.exp(-c1) / c1;
            double c3 = 1.0 / shape;
            do {
                u1 = random.nextDouble();
                u2 = random.nextDouble();
            } while (!((v = c2 * u1) <= 1.0 ? u2 <= (2.0 - (x = c1 * MathFunctions.pow(v, c3))) / (2.0 + x) || u2 <= MathFunctions.exp(-x) : u2 * (shape + (y = (x = -MathFunctions.log(c1 * c3 * (c2 - v))) / c1) - shape * y) <= 1.0 || u2 < MathFunctions.pow(y, shape - 1.0)));
            return x;
        }
    }

    static abstract class BaseGammaRNG
    implements GammaRNG {
        BaseGammaRNG() {
        }

        @Override
        public double generate(Random random, double shape, double scale) {
            return this.generate(random, shape) * scale;
        }

        abstract double generate(Random var1, double var2);

        public String toString() {
            return String.format("%s", this.getClass().getSimpleName());
        }
    }
}

