/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.rng;

import biz.k11i.rng.ExponentialRNG;
import biz.k11i.rng.GammaRNGAlgorithms;
import biz.k11i.rng.GaussianRNG;
import java.util.Random;

public interface GammaRNG {
    public static final GammaRNG FAST_RNG = new FastRNG();
    public static final GammaRNG GENERAL_RNG = new GeneralRNG();

    public double generate(Random var1, double var2, double var4);

    public static class GeneralRNG
    implements GammaRNG {
        private final GammaRNG best = new GammaRNGAlgorithms.Best();
        private final GammaRNG mt = new GammaRNGAlgorithms.MarsagliaTsang(GaussianRNG.GENERAL_RNG);
        private final GammaRNG exponential = new GammaRNGAlgorithms.Exponential(ExponentialRNG.GENERAL_RNG);
        private final GammaRNG wh = new GammaRNGAlgorithms.WilsonHilfertyApproximation(GaussianRNG.GENERAL_RNG);

        @Override
        public double generate(Random random, double shape, double scale) {
            if (shape >= 50.0) {
                return this.wh.generate(random, shape, scale);
            }
            if (shape < 0.1) {
                return this.best.generate(random, shape, scale);
            }
            if (shape != 1.0) {
                return this.mt.generate(random, shape, scale);
            }
            return this.exponential.generate(random, shape, scale);
        }
    }

    public static class FastRNG
    implements GammaRNG {
        private final GammaRNG mt = new GammaRNGAlgorithms.MarsagliaTsang(GaussianRNG.FAST_RNG);
        private final GammaRNG exponential = new GammaRNGAlgorithms.Exponential(ExponentialRNG.FAST_RNG);
        private final GammaRNG wh = new GammaRNGAlgorithms.WilsonHilfertyApproximation(GaussianRNG.FAST_RNG);

        @Override
        public double generate(Random random, double shape, double scale) {
            if (shape >= 50.0) {
                return this.wh.generate(random, shape, scale);
            }
            if (shape != 1.0) {
                return this.mt.generate(random, shape, scale);
            }
            return this.exponential.generate(random, shape, scale);
        }
    }
}

