/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.rng;

import biz.k11i.util.MathFunctions;
import java.util.Random;

public interface ExponentialRNG {
    public static final ExponentialRNG FAST_RNG = ZigguratFast.access$000();
    public static final ExponentialRNG GENERAL_RNG = ZigguratGeneral.access$100();

    public double generate(Random var1, double var2);

    public static class ZigguratGeneral
    extends ZigguratBase
    implements ExponentialRNG {
        private static final ZigguratGeneral Z_256 = new ZigguratGeneral(8, 7.697117470131, 0.00394965982258);
        private final double[] x;
        private final double[] t;

        ZigguratGeneral(int nBits, double r, double v) {
            super(nBits, r, v);
            int i;
            this.x = new double[this.N + 1];
            this.t = new double[this.N];
            this.x[this.N] = v * MathFunctions.exp(r);
            this.x[this.N - 1] = r;
            for (i = this.N - 2; i >= 1; --i) {
                this.x[i] = ZigguratGeneral.finv(this.x[i + 1], v);
            }
            this.x[0] = 0.0;
            for (i = 0; i < this.N; ++i) {
                this.t[i] = this.x[i] / this.x[i + 1];
            }
        }

        @Override
        double generate(Random random, int recursiveCount) {
            double y;
            double gl;
            double gu;
            do {
                int i = (int)(random.nextLong() & (long)this.INDEX_BIT_MASK);
                double u1 = random.nextDouble();
                if (u1 < this.t[i]) {
                    return u1 * this.x[i + 1];
                }
                if (i == this.TAIL_INDEX) {
                    if (recursiveCount < 2) {
                        return this.R + this.generate(random, recursiveCount + 1);
                    }
                    return this.R - MathFunctions.log1p(-random.nextDouble());
                }
                y = u1 * this.x[i + 1];
                gu = MathFunctions.exp(-(this.x[i] - y));
                gl = MathFunctions.exp(-(this.x[i + 1] - y));
            } while (!(random.nextDouble() * (gu - gl) <= 1.0 - gl));
            return y;
        }

        static /* synthetic */ ZigguratGeneral access$100() {
            return Z_256;
        }
    }

    public static class ZigguratFast
    extends ZigguratBase
    implements ExponentialRNG {
        private static final ZigguratFast Z_256 = new ZigguratFast(8, 7.697117470131, 0.00394965982258);
        private final int INDEX_BITS;
        private final long[] k;
        private final double[] w;
        private final double[] f;

        ZigguratFast(int nBits, double r, double v) {
            super(nBits, r, v);
            this.INDEX_BITS = nBits;
            this.w = new double[this.N];
            this.k = new long[this.N];
            this.f = new double[this.N];
            long b = 1L << 64 - nBits;
            this.w[this.N - 1] = v * MathFunctions.exp(r) / (double)b;
            this.w[this.N - 2] = r / (double)b;
            this.k[this.N - 1] = (long)Math.floor(r / this.w[this.N - 1]);
            this.f[this.N - 1] = MathFunctions.exp(-r);
            double x = r;
            for (int i = this.N - 2; i >= 1; --i) {
                x = ZigguratFast.finv(x, v);
                this.w[i - 1] = x / (double)b;
                this.k[i] = (long)Math.floor(x / this.w[i]);
                this.f[i] = MathFunctions.exp(-x);
            }
            this.k[0] = 0L;
            this.f[0] = 1.0;
        }

        @Override
        double generate(Random random, int recursiveCount) {
            double x;
            double fx;
            int i;
            do {
                long u = random.nextLong();
                if ((u >>>= this.INDEX_BITS) < this.k[i = (int)(u & (long)this.INDEX_BIT_MASK)]) {
                    return (double)u * this.w[i];
                }
                if (i == this.TAIL_INDEX) {
                    if (recursiveCount < 2) {
                        return this.R + this.generate(random, recursiveCount + 1);
                    }
                    return this.R - MathFunctions.log1p(-random.nextDouble());
                }
                x = (double)u * this.w[i];
                fx = MathFunctions.exp(-x);
            } while (!(random.nextDouble() * (this.f[i] - this.f[i + 1]) <= fx - this.f[i + 1]));
            return x;
        }

        static /* synthetic */ ZigguratFast access$000() {
            return Z_256;
        }
    }

    public static abstract class ZigguratBase
    implements ExponentialRNG {
        final int N;
        final double R;
        final double V;
        final int INDEX_BIT_MASK;
        final int TAIL_INDEX;

        ZigguratBase(int nBits, double r, double v) {
            this.N = 1 << nBits;
            this.R = r;
            this.V = v;
            this.INDEX_BIT_MASK = (1 << nBits) - 1;
            this.TAIL_INDEX = (1 << nBits) - 1;
        }

        static double finv(double x, double v) {
            return -MathFunctions.log(MathFunctions.exp(-x) + v / x);
        }

        @Override
        public double generate(Random random, double theta) {
            return theta * this.generate(random, 0);
        }

        abstract double generate(Random var1, int var2);
    }
}

