/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.rng;

import biz.k11i.rng.BetaRNG;
import biz.k11i.rng.GammaRNG;
import biz.k11i.util.MathFunctions;
import java.util.Random;

class BetaRNGAlgorithms {
    BetaRNGAlgorithms() {
    }

    static class Unif
    implements BetaRNG {
        static final BetaRNG INSTANCE = new Unif();

        Unif() {
        }

        @Override
        public double generate(Random random, double ignore1, double ignore2) {
            return random.nextDouble();
        }
    }

    static class CdfInversion
    implements BetaRNG {
        static final BetaRNG INSTANCE = new CdfInversion();

        CdfInversion() {
        }

        @Override
        public double generate(Random random, double alpha, double beta) {
            return alpha == 1.0 ? 1.0 - MathFunctions.pow(random.nextDouble(), 1.0 / beta) : MathFunctions.pow(random.nextDouble(), 1.0 / alpha);
        }
    }

    static class TwoGammaVariates
    implements BetaRNG {
        private final GammaRNG gammaRNG;

        TwoGammaVariates(GammaRNG gammaRNG) {
            this.gammaRNG = gammaRNG;
        }

        @Override
        public double generate(Random random, double alpha, double beta) {
            double a = this.gammaRNG.generate(random, alpha, 1.0);
            if (a == 0.0) {
                return 0.0;
            }
            return a / (a + this.gammaRNG.generate(random, beta, 1.0));
        }
    }

    static class B00
    implements BetaRNG {
        static final BetaRNG INSTANCE = new B00();

        B00() {
        }

        @Override
        public double generate(Random random, double alpha, double beta) {
            double x;
            double t = (1.0 - alpha) / (2.0 - alpha - beta);
            double s = (beta - alpha) * (1.0 - alpha - beta);
            double r = alpha * (1.0 - alpha);
            t -= ((s * t + 2.0 * r) * t - r) / 2.0 * (s * t + r);
            double p = t / alpha;
            double q = (1.0 - t) / beta;
            s = MathFunctions.pow(1.0 - t, beta - 1.0);
            double c = MathFunctions.pow(t, alpha - 1.0);
            r = (c - 1.0) / (t - 1.0);
            while (true) {
                double u = random.nextDouble() * (p + q);
                double v = random.nextDouble();
                if (u <= p) {
                    x = t * MathFunctions.pow(u / p, 1.0 / alpha);
                    if ((v *= s) < (1.0 - beta) * x + 1.0) {
                        return x;
                    }
                    if (!(v < (s - 1.0) * x / t + 1.0) || !(v <= MathFunctions.pow(1.0 - x, beta - 1.0))) continue;
                    return x;
                }
                x = 1.0 - (1.0 - t) * MathFunctions.pow((u - p) / q, 1.0 / beta);
                if ((v *= c) < (alpha - 1.0) * (x - 1.0) + 1.0) {
                    return x;
                }
                if (v <= r * (x - 1.0) + 1.0 && v <= MathFunctions.pow(x, alpha - 1.0)) break;
            }
            return x;
        }
    }

    static class Johnk
    implements BetaRNG {
        static final BetaRNG INSTANCE = new Johnk();

        Johnk() {
        }

        @Override
        public double generate(Random random, double alpha, double beta) {
            double v;
            double vv;
            double u;
            double uu;
            double w;
            do {
                u = MathFunctions.log(random.nextDouble()) / alpha;
                v = MathFunctions.log(random.nextDouble()) / beta;
            } while (!((w = (uu = MathFunctions.exp(u)) + (vv = MathFunctions.exp(v))) <= 1.0));
            if (w > 0.0) {
                return uu / w;
            }
            double logM = u > v ? u : v;
            return MathFunctions.exp((u -= logM) - MathFunctions.log(MathFunctions.exp(u) + MathFunctions.exp(v -= logM)));
        }
    }
}

