/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.rng;

import biz.k11i.rng.BetaRNGAlgorithms;
import biz.k11i.rng.GammaRNG;
import java.util.Random;

public interface BetaRNG {
    public static final BetaRNG FAST_RNG = new BetaRNGImpl(GammaRNG.FAST_RNG);
    public static final BetaRNG GENERAL_RNG = new BetaRNGImpl(GammaRNG.GENERAL_RNG);

    public double generate(Random var1, double var2, double var4);

    public static class BetaRNGImpl
    implements BetaRNG {
        private static final double[] CASE2_MAX_THRESHOLDS = new double[11];
        private final BetaRNG twoGammaVariates;

        BetaRNGImpl(GammaRNG gammaRNG) {
            this.twoGammaVariates = new BetaRNGAlgorithms.TwoGammaVariates(gammaRNG);
        }

        @Override
        public double generate(Random random, double alpha, double beta) {
            return (alpha <= beta ? this.selectAlgorithm(alpha, beta) : this.selectAlgorithm(beta, alpha)).generate(random, alpha, beta);
        }

        BetaRNG selectAlgorithm(double min, double max) {
            if (min > 1.0) {
                return this.twoGammaVariates;
            }
            if (max < 1.0) {
                return max + min <= 1.5 ? BetaRNGAlgorithms.Johnk.INSTANCE : BetaRNGAlgorithms.B00.INSTANCE;
            }
            if (min < 0.1 && max <= CASE2_MAX_THRESHOLDS[(int)(min * 100.0)]) {
                return BetaRNGAlgorithms.Johnk.INSTANCE;
            }
            if (max > 1.0) {
                return this.twoGammaVariates;
            }
            if (min == 1.0) {
                return BetaRNGAlgorithms.Unif.INSTANCE;
            }
            return BetaRNGAlgorithms.CdfInversion.INSTANCE;
        }

        static {
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[0] = 90.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[1] = 70.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[2] = 50.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[3] = 12.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[4] = 6.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[5] = 3.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[6] = 2.5;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[7] = 2.0;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[8] = 1.6;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[9] = 1.3;
            BetaRNGImpl.CASE2_MAX_THRESHOLDS[10] = 1.0;
        }
    }
}

