/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.util;

public final class MathFunctions {
    public static final double log(double value) {
        return CommonsMath.log(value);
    }

    public static final double log1p(double value) {
        return JafamaMath.log1p(value);
    }

    public static final double exp(double value) {
        return JafamaMath.exp(value);
    }

    public static final double expm1(double value) {
        return JafamaMath.expm1(value);
    }

    public static final double pow(double value, double power) {
        return JafamaMath.pow(value, power);
    }

    private static final class JafamaMath {
        static final double TWO_POW_52 = JafamaMath.twoPow(52);
        static final double DOUBLE_MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
        static final int MIN_DOUBLE_EXPONENT = -1074;
        static final int MAX_DOUBLE_EXPONENT = 1023;
        static final double LOG_2 = StrictMath.log(2.0);
        static final double EXP_OVERFLOW_LIMIT = Double.longBitsToDouble(4649454530587146735L);
        static final double EXP_UNDERFLOW_LIMIT = Double.longBitsToDouble(-4573606559926636463L);
        static final int EXP_LO_DISTANCE_TO_ZERO_POT = 0;
        static final int EXP_LO_DISTANCE_TO_ZERO = 1;
        static final int EXP_LO_TAB_SIZE_POT = JafamaMath.getTabSizePower(11);
        static final int EXP_LO_TAB_SIZE = (1 << EXP_LO_TAB_SIZE_POT) + 1;
        static final int EXP_LO_TAB_MID_INDEX = (EXP_LO_TAB_SIZE - 1) / 2;
        static final int EXP_LO_INDEXING = EXP_LO_TAB_MID_INDEX / 1;
        static final int EXP_LO_INDEXING_DIV_SHIFT = EXP_LO_TAB_SIZE_POT - 1 - 0;
        static final int LOG_BITS = JafamaMath.getTabSizePower(12);
        static final int LOG_TAB_SIZE = 1 << LOG_BITS;

        private JafamaMath() {
        }

        static final double exp(double value) {
            if (value > EXP_OVERFLOW_LIMIT) {
                return Double.POSITIVE_INFINITY;
            }
            if (!(value >= EXP_UNDERFLOW_LIMIT)) {
                return value != value ? Double.NaN : 0.0;
            }
            int indexes = (int)(value * (double)EXP_LO_INDEXING);
            int valueInt = indexes >= 0 ? indexes >> EXP_LO_INDEXING_DIV_SHIFT : -(-indexes >> EXP_LO_INDEXING_DIV_SHIFT);
            double hiTerm = MyTExp.expHiTab[valueInt - (int)EXP_UNDERFLOW_LIMIT];
            int zIndex = indexes - (valueInt << EXP_LO_INDEXING_DIV_SHIFT);
            double y = value - (double)valueInt;
            double z = (double)zIndex * (1.0 / (double)EXP_LO_INDEXING);
            double eps = y - z;
            double expZ = MyTExp.expLoPosTab[zIndex + EXP_LO_TAB_MID_INDEX];
            double expEps = 1.0 + eps * (1.0 + eps * (0.5 + eps * (0.16666666666666666 + eps * 0.041666666666666664)));
            double loTerm = expZ * expEps;
            return hiTerm * loTerm;
        }

        public static double expm1(double value) {
            if (Math.abs(value) < 1.0) {
                int i = (int)(value * (double)EXP_LO_INDEXING);
                double delta = value - (double)i * (1.0 / (double)EXP_LO_INDEXING);
                return MyTExp.expLoPosTab[i + EXP_LO_TAB_MID_INDEX] * (MyTExp.expLoNegTab[i + EXP_LO_TAB_MID_INDEX] + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * (0.041666666666666664 + delta * 0.008333333333333333)))));
            }
            return JafamaMath.exp(value) - 1.0;
        }

        static final double log(double value) {
            if (value > 0.0) {
                double h;
                if (value == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                if (value > 0.95) {
                    if (value < 1.14) {
                        double z = (value - 1.0) / (value + 1.0);
                        double z2 = z * z;
                        return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                    }
                    h = 0.0;
                } else if (value < DOUBLE_MIN_NORMAL) {
                    value *= TWO_POW_52;
                    h = -52.0 * LOG_2;
                } else {
                    h = 0.0;
                }
                int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
                int valueExp = (valueBitsHi >> 20) - 1023;
                int xIndex = valueBitsHi << 12 >>> 32 - LOG_BITS;
                double z = value * JafamaMath.twoPowNormalOrSubnormal(-valueExp) * MyTLog.logXInvTab[xIndex] - 1.0;
                z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
                return h + (double)valueExp * LOG_2 + (MyTLog.logXLogTab[xIndex] + z);
            }
            if (value == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.NaN;
        }

        static final double log1p(double value) {
            if (value > -1.0) {
                if (value == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                double valuePlusOne = 1.0 + value;
                if (valuePlusOne == 1.0) {
                    return value;
                }
                if (Math.abs(value) < 0.15) {
                    double z = value / (value + 2.0);
                    double z2 = z * z;
                    return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                }
                int valuePlusOneBitsHi = (int)(Double.doubleToRawLongBits(valuePlusOne) >> 32) & Integer.MAX_VALUE;
                int valuePlusOneExp = (valuePlusOneBitsHi >> 20) - 1023;
                int xIndex = valuePlusOneBitsHi << 12 >>> 32 - LOG_BITS;
                double z = valuePlusOne * JafamaMath.twoPowNormalOrSubnormal(-valuePlusOneExp) * MyTLog.logXInvTab[xIndex] - 1.0;
                z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
                return (double)valuePlusOneExp * LOG_2 + MyTLog.logXLogTab[xIndex] + (z + (value - (valuePlusOne - 1.0)) / valuePlusOne);
            }
            if (value == -1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.NaN;
        }

        static final double pow(double value, double power) {
            if (power == 0.0) {
                return 1.0;
            }
            if (power == 1.0) {
                return value;
            }
            if (value <= 0.0) {
                int powerInfo;
                if (Math.abs(power) >= TWO_POW_52 * 2.0) {
                    powerInfo = 1;
                } else if (Math.abs(power) <= 2.147483647E9) {
                    int powerAsInt = (int)power;
                    powerInfo = power == (double)powerAsInt ? ((powerAsInt & 1) == 0 ? 1 : -1) : 0;
                } else {
                    long powerAsLong = (long)power;
                    if (power == (double)powerAsLong) {
                        powerInfo = (powerAsLong & 1L) == 0L ? 1 : -1;
                    } else {
                        if (power != power) {
                            return Double.NaN;
                        }
                        powerInfo = 0;
                    }
                }
                if (value == 0.0) {
                    if (power < 0.0) {
                        return powerInfo < 0 ? 1.0 / value : Double.POSITIVE_INFINITY;
                    }
                    return powerInfo < 0 ? value : 0.0;
                }
                if (value == Double.NEGATIVE_INFINITY) {
                    if (powerInfo < 0) {
                        return power < 0.0 ? -0.0 : Double.NEGATIVE_INFINITY;
                    }
                    return power < 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
                }
                return powerInfo == 0 ? Double.NaN : (double)powerInfo * JafamaMath.exp(power * JafamaMath.log(-value));
            }
            return JafamaMath.exp(power * JafamaMath.log(value));
        }

        private static final double twoPowNormalOrSubnormal(int power) {
            if (power <= -1023) {
                return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
            }
            return Double.longBitsToDouble((long)(power + 1023) << 52);
        }

        private static final int getTabSizePower(int tabSizePower) {
            return tabSizePower;
        }

        private static final double twoPow(int power) {
            if (power <= -1023) {
                if (power >= -1074) {
                    return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
                }
                return 0.0;
            }
            if (power > 1023) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.longBitsToDouble((long)(power + 1023) << 52);
        }

        static final class MyTLog {
            static final double[] logXLogTab = new double[LOG_TAB_SIZE];
            static final double[] logXTab = new double[LOG_TAB_SIZE];
            static final double[] logXInvTab = new double[LOG_TAB_SIZE];

            MyTLog() {
            }

            private static strictfp void init() {
                for (int i = 0; i < LOG_TAB_SIZE; ++i) {
                    double x = 1.0 + (double)i * (1.0 / (double)LOG_TAB_SIZE);
                    MyTLog.logXLogTab[i] = StrictMath.log(x);
                    MyTLog.logXTab[i] = x;
                    MyTLog.logXInvTab[i] = 1.0 / x;
                }
            }

            static {
                MyTLog.init();
            }
        }

        static final class MyTExp {
            static final double[] expHiTab = new double[1 + (int)EXP_OVERFLOW_LIMIT - (int)EXP_UNDERFLOW_LIMIT];
            static final double[] expLoPosTab = new double[EXP_LO_TAB_SIZE];
            static final double[] expLoNegTab = new double[EXP_LO_TAB_SIZE];

            MyTExp() {
            }

            private static strictfp void init() {
                int i;
                for (i = (int)EXP_UNDERFLOW_LIMIT; i <= (int)EXP_OVERFLOW_LIMIT; ++i) {
                    MyTExp.expHiTab[i - (int)JafamaMath.EXP_UNDERFLOW_LIMIT] = StrictMath.exp(i);
                }
                for (i = 0; i < EXP_LO_TAB_SIZE; ++i) {
                    double x = -1.0 + (double)i / (double)EXP_LO_INDEXING;
                    MyTExp.expLoPosTab[i] = StrictMath.exp(x);
                    MyTExp.expLoNegTab[i] = -StrictMath.expm1(-x);
                }
            }

            static {
                MyTExp.init();
            }
        }
    }

    private static final class CommonsMath {
        private static final double LN_2_A = 0.6931470632553101;
        private static final double LN_2_B = 1.1730463525082348E-7;
        private static final long HEX_40000000 = 0x40000000L;
        private static final double TWO_POWER_52 = 4.503599627370496E15;
        private static final double[][] LN_QUICK_COEF = new double[][]{{1.0, 5.669184079525E-24}, {-0.25, -0.25}, {0.3333333134651184, 1.986821492305628E-8}, {-0.25, -6.663542893624021E-14}, {0.19999998807907104, 1.1921056801463227E-8}, {-0.1666666567325592, -7.800414592973399E-9}, {0.1428571343421936, 5.650007086920087E-9}, {-0.1250253f, -7.44321345601866E-11}, {0.11113807559013367, 9.219544613762692E-9}};

        private CommonsMath() {
        }

        static final double log(double x) {
            if (x == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            long bits = Double.doubleToRawLongBits(x);
            if ((bits & Long.MIN_VALUE) != 0L || x != x) {
                return Double.NaN;
            }
            if (x == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            int exp = (int)(bits >> 52) - 1023;
            if ((bits & 0x7FF0000000000000L) == 0L) {
                bits <<= 1;
                while ((bits & 0x10000000000000L) == 0L) {
                    --exp;
                    bits <<= 1;
                }
            }
            if ((exp == -1 || exp == 0) && x < 1.01 && x > 0.99) {
                double xa = x - 1.0;
                double tmp = xa * 1.073741824E9;
                double aa = xa + tmp - tmp;
                double ab = xa - aa;
                xa = aa;
                double xb = ab;
                double[] lnCoef_last = LN_QUICK_COEF[LN_QUICK_COEF.length - 1];
                double ya = lnCoef_last[0];
                double yb = lnCoef_last[1];
                for (int i = LN_QUICK_COEF.length - 2; i >= 0; --i) {
                    aa = ya * xa;
                    ab = ya * xb + yb * xa + yb * xb;
                    tmp = aa * 1.073741824E9;
                    ya = aa + tmp - tmp;
                    yb = aa - ya + ab;
                    double[] lnCoef_i = LN_QUICK_COEF[i];
                    aa = ya + lnCoef_i[0];
                    ab = yb + lnCoef_i[1];
                    tmp = aa * 1.073741824E9;
                    ya = aa + tmp - tmp;
                    yb = aa - ya + ab;
                }
                aa = ya * xa;
                ab = ya * xb + yb * xa + yb * xb;
                tmp = aa * 1.073741824E9;
                ya = aa + tmp - tmp;
                yb = aa - ya + ab;
                return ya + yb;
            }
            double[] lnm = lnMant.LN_MANT[(int)((bits & 0xFFC0000000000L) >> 42)];
            double epsilon = (double)(bits & 0x3FFFFFFFFFFL) / (4.503599627370496E15 + (double)(bits & 0xFFC0000000000L));
            double lnza = 0.0;
            double lnzb = 0.0;
            lnza = -0.16624882440418567;
            lnza = lnza * epsilon + 0.19999954120254515;
            lnza = lnza * epsilon + -0.2499999997677497;
            lnza = lnza * epsilon + 0.3333333333332802;
            lnza = lnza * epsilon + -0.5;
            lnza = lnza * epsilon + 1.0;
            lnza *= epsilon;
            double a = 0.6931470632553101 * (double)exp;
            double b = 0.0;
            double c = a + lnm[0];
            double d = -(c - a - lnm[0]);
            a = c;
            b += d;
            c = a + lnza;
            d = -(c - a - lnza);
            a = c;
            b += d;
            c = a + 1.1730463525082348E-7 * (double)exp;
            d = -(c - a - 1.1730463525082348E-7 * (double)exp);
            a = c;
            b += d;
            c = a + lnm[1];
            d = -(c - a - lnm[1]);
            a = c;
            b += d;
            c = a + lnzb;
            d = -(c - a - lnzb);
            a = c;
            return a + (b += d);
        }

        private static class lnMant {
            private static final double[][] LN_MANT = new double[][]{{0.0, 0.0}, {9.76086E-4f, -3.903230345984362E-11}, {0.0019512202125042677, -8.124251825289188E-11}, {0.0029254043474793434, -1.8374207360194882E-11}, {0.0038986406289041042, -2.1324678121885073E-10}, {0.004870930686593056, -4.5199654318611534E-10}, {0.00584227591753006, -2.933016992001806E-10}, {0.006812678650021553, -2.325147219074669E-10}, {0.007782140746712685, -3.046577356838847E-10}, {0.008750664070248604, -5.500631513861575E-10}, {0.00971824862062931, 8.48292035519895E-10}, {0.0106849f, 1.1422610134013436E-10}, {0.01165061630308628, 9.168889933128375E-10}, {0.012615403160452843, -5.303786078838E-10}, {0.013579258695244789, -5.688639355498786E-10}, {0.01454218477010727, 7.296670293275653E-10}, {0.015504186972975731, -4.370104767451421E-10}, {0.016465261578559875, 1.43695591408832E-9}, {0.01742541790008545, -1.1862263158849434E-9}, {0.01838465f, -9.482976524690715E-10}, {0.01934296265244484, 1.9068609515836638E-10}, {0.020300358533859253, 2.655990315697216E-10}, {0.021256837993860245, 1.0315548713040775E-9}, {0.022212404757738113, 5.13345647019085E-10}, {0.02316705882549286, 4.5604151934208014E-10}, {0.02412080392241478, -1.1255706987475148E-9}, {0.025073636323213577, 1.2289023836765196E-9}, {0.02602556347846985, 1.7990281828096504E-9}, {0.02697659f, -1.4152718164638451E-9}, {0.02792670577764511, 7.568772963781632E-10}, {0.0288759246468544, -1.1449998592111558E-9}, {0.029824241995811462, -1.6850976862319495E-9}, {0.030771657824516296, 8.422373919843096E-10}, {0.0317181795835495, 6.872350402175489E-10}, {0.03266380727291107, -4.541194749189272E-10}, {0.03360854089260101, -8.9064764856495E-10}, {0.03455238f, 1.0640404096769032E-9}, {0.0354953333735466, -3.5901655945224663E-10}, {0.0364374f, -3.4829517943661266E-9}, {0.037378571927547455, 8.149473794244232E-10}, {0.03831886500120163, -6.990650304449166E-10}, {0.03925827145576477, 1.0883076226453258E-9}, {0.0401968f, 3.845192807999274E-10}, {0.04113444685935974, -1.1570594692045927E-9}, {0.04207121580839157, -1.8877045166697178E-9}, {0.043007105588912964, -1.6332083257987747E-10}, {0.04394212365150452, -1.7950057534514933E-9}, {0.04487626254558563, 2.302710041648838E-9}, {0.045809537172317505, -1.1410233017161343E-9}, {0.04674194008111954, -3.0498741599744685E-9}, {0.04767347127199173, -1.8026348269183678E-9}, {0.04860413819551468, -3.233204600453039E-9}, {0.04953393340110779, 1.7211688427961583E-9}, {0.05046287178993225, -2.329967807055457E-10}, {0.05139094591140747, -4.191810118556531E-11}, {0.052318163216114044, -3.5574324788328143E-9}, {0.053244516253471375, -1.7346590916458485E-9}, {0.05417001247406006, -4.343048751383674E-10}, {0.055094651877880096, 1.92909364037955E-9}, {0.056018441915512085, -5.139745677199588E-10}, {0.05694137513637543, 1.2637629975129189E-9}, {0.05786345899105072, 1.3840561112481119E-9}, {0.058784693479537964, 1.414889689612056E-9}, {0.05970507860183716, 2.9199191907666474E-9}, {0.0606246218085289, 7.90594243412116E-12}, {0.06154331564903259, 1.6844747839686189E-9}, {0.06246116757392883, 2.0498074572151747E-9}, {0.06337818503379822, -4.800180493433863E-9}, {0.06429435312747955, -2.4220822960064277E-9}, {0.06520968675613403, -4.179048566709334E-9}, {0.06612417101860046, 6.363872957010456E-9}, {0.06703783571720123, 9.339468680056365E-10}, {0.06795066595077515, -4.04226739708981E-9}, {0.0688626617193222, -7.043545052852817E-9}, {0.06977382302284241, -6.552819560439773E-9}, {0.07068414986133575, -1.0571674860370546E-9}, {0.07159365713596344, -3.948954622015801E-9}, {0.07250232994556427, 1.1776625988228244E-9}, {0.07341018319129944, 9.221072639606492E-10}, {0.07431721687316895, -3.219119568928366E-9}, {0.0752234160900116, 5.147575929018918E-9}, {0.07612881064414978, -2.291749683541979E-9}, {0.07703337073326111, 5.749565906124772E-9}, {0.07793712615966797, 9.495158151301779E-10}, {0.07884006202220917, -3.144331429489291E-10}, {0.0797421783208847, 3.430029236134205E-9}, {0.08064348995685577, -1.2499290483167703E-9}, {0.08154398202896118, 2.011215719133196E-9}, {0.08244366943836212, -2.2728753031387152E-10}, {0.0833425521850586, -6.508966857277253E-9}, {0.0842406153678894, -4.801131671405377E-10}, {0.08513787388801575, 4.406750291994231E-9}, {0.08603434264659882, -5.304795662536171E-9}, {0.08692999184131622, 1.6284313912612293E-9}, {0.08782485127449036, -3.158898981674071E-9}, {0.08871890604496002, -3.3324878834139977E-9}, {0.08961215615272522, 2.536961912893389E-9}, {0.09050461649894714, 9.737596728980696E-10}, {0.0913962870836258, -6.600437262505396E-9}, {0.09228715300559998, -3.866609889222889E-9}, {0.09317722916603088, -4.311847594020281E-9}, {0.09406651556491852, -6.525851105645959E-9}, {0.094955f, 5.799080912675435E-9}, {0.09584270417690277, 4.2634204358490415E-9}, {0.09672962129116058, 5.167390528799477E-9}, {0.09761576354503632, -4.994827392841906E-9}, {0.0985011f, 4.970725577861395E-9}, {0.09938566386699677, 6.6496705953229645E-9}, {0.10026945173740387, 1.4262712796792241E-9}, {0.1011524498462677, 5.5822855204629114E-9}, {0.10203467309474945, 5.593494835247651E-9}, {0.10291612148284912, 2.8332008343480686E-9}, {0.10379679501056671, -1.3289231465997192E-9}, {0.10467669367790222, -5.526819276639527E-9}, {0.1055558f, 6.503128678219282E-9}, {0.10643415153026581, 6.317463237641817E-9}, {0.10731174051761627, -4.728528221305482E-9}, {0.10818853974342346, 4.519199083083901E-9}, {0.10906457901000977, 5.606492666349878E-9}, {0.10993985831737518, -1.220176214398581E-10}, {0.11081436276435852, 3.5759315936869937E-9}, {0.11168810725212097, 3.1367659571899855E-9}, {0.11256109178066254, -1.0543075713098835E-10}, {0.11343331634998322, -4.820065619207094E-9}, {0.11430476605892181, 5.221136819669415E-9}, {0.11517547070980072, 1.5395018670011342E-9}, {0.11604541540145874, 3.5638391501880846E-10}, {0.1169146f, 2.9885336757136527E-9}, {0.11778303980827332, -4.151889860890893E-9}, {0.11865071952342987, -4.853823938804204E-9}, {0.11951763927936554, 2.189226237170704E-9}, {0.12038381397724152, 3.3791993048776982E-9}, {0.1212492436170578, 1.5811884868243975E-11}, {0.12211392819881439, -6.6045909118908625E-9}, {0.1229778528213501, -2.8786263916116364E-10}, {0.12384103238582611, 5.354472503748251E-9}, {0.12470348179340363, -3.2924463896248744E-9}, {0.12556517124176025, 4.856678149580005E-9}, {0.12642613053321838, 1.2791850600366742E-9}, {0.12728634476661682, 2.1525945093362843E-9}, {0.12814581394195557, 8.749974471767862E-9}, {0.129004567861557, -7.461209161105275E-9}, {0.12986254692077637, 1.4390208226263824E-8}, {0.1307198405265808, -1.3839477920475328E-8}, {0.13157635927200317, -1.483283901239408E-9}, {0.13243216276168823, -6.889072914229094E-9}, {0.1332872211933136, 9.990351100568362E-10}, {0.13414156436920166, -6.370937412495338E-9}, {0.13499516248703003, 2.05047480130511E-9}, {0.1358480453491211, -2.29509872547079E-9}, {0.13670018315315247, 1.16354361977249E-8}, {0.13755163550376892, -1.452496267904829E-8}, {0.1384023129940033, 9.865115839786888E-9}, {0.1392523f, -3.369999130712228E-9}, {0.14010155200958252, 6.602496401651853E-9}, {0.14095008373260498, 1.1205312852298845E-8}, {0.1417979f, 1.1660367213160203E-8}, {0.142645001411438, 9.186471222585239E-9}, {0.14349138736724854, 4.999341878263704E-9}, {0.14433705806732178, 3.11611905696257E-10}, {0.14518201351165771, -3.6671598175618173E-9}, {0.14602625370025635, -5.730477881659618E-9}, {0.14686977863311768, -4.674900007989718E-9}, {0.1477125883102417, 6.999732437141968E-10}, {0.14855468273162842, 1.159150872494107E-8}, {0.14939609169960022, -6.082714828488485E-10}, {0.15023678541183472, -4.905712741596318E-9}, {0.1510767638683319, -1.124848988733307E-10}, {0.15191605687141418, -1.484557220949851E-8}, {0.1527546f, 1.1682026251371384E-8}, {0.1535925f, -8.757272519238786E-9}, {0.15442964434623718, 1.4419920764774415E-8}, {0.15526613593101501, -7.019891063126053E-9}, {0.15610191226005554, -1.230153548825964E-8}, {0.15693697333335876, -2.574172005933276E-10}, {0.15777134895324707, 4.748140799544371E-10}, {0.15860503911972046, -8.943081874891003E-9}, {0.15943801403045654, 2.4500739038517657E-9}, {0.1602703034877777, 6.007922084557054E-9}, {0.16110190749168396, 2.8835418231126645E-9}, {0.1619328260421753, -5.772862039728412E-9}, {0.16276302933692932, 1.0988372954605789E-8}, {0.16359257698059082, -5.292913162607026E-9}, {0.16442140936851501, 6.12956339275823E-9}, {0.16524958610534668, -1.3210039516811888E-8}, {0.16607704758644104, -2.5711014608334873E-9}, {0.16690382361412048, 9.37721319457112E-9}, {0.1677299439907074, -6.0370682395944045E-9}, {0.168555349111557, 1.1918249660105651E-8}, {0.1693800985813141, 4.763282949656017E-9}, {0.17020416259765625, 3.4223342273948817E-9}, {0.1710275411605835, 9.014612241310916E-9}, {0.1718502640724182, -7.145758990550526E-9}, {0.172672301530838, -1.4142763934081504E-8}, {0.1734936535358429, -1.0865453656579032E-8}, {0.17431432008743286, 3.794385569450774E-9}, {0.1751343309879303, 1.1399188501627291E-9}, {0.17595365643501282, 1.2076238768270153E-8}, {0.1767723262310028, 7.901084730502162E-9}, {0.17759034037590027, -1.0288181007465474E-8}, {0.1784076690673828, -1.15945645153806E-8}, {0.17922431230545044, 5.073923825786778E-9}, {0.1800403f, 1.1004278077575267E-8}, {0.1808556318283081, 7.2831502374676964E-9}, {0.18167030811309814, -5.0054634662706464E-9}, {0.1824843f, 5.022108460298934E-9}, {0.18329763412475586, 8.642254225732676E-9}, {0.18411031365394592, 6.931054493326395E-9}, {0.18492233753204346, 9.619685356326533E-10}, {0.1857337f, -8.194157257980706E-9}, {0.18654438853263855, 1.0333241479437797E-8}, {0.1873544454574585, -1.9948340196027965E-9}, {0.1881638467311859, -1.4313002926259948E-8}, {0.1889725625514984, 4.241536392174967E-9}, {0.18978065252304077, -4.877952454011428E-9}, {0.1905880868434906, -1.0813801247641613E-8}, {0.1913948655128479, -1.2513218445781325E-8}, {0.19220098853111267, -8.925958555729115E-9}, {0.1930064558982849, 9.956860681280245E-10}, {0.193811297416687, -1.1505428993246996E-8}, {0.1946154534816742, 1.4217997464522202E-8}, {0.19541901350021362, -1.0200858727747717E-8}, {0.19622188806533813, 5.682607223902455E-9}, {0.1970241367816925, 3.2988908516009827E-9}, {0.19782572984695435, 1.3482965534659446E-8}, {0.1986267f, 7.462678536479685E-9}, {0.1994270384311676, -1.3734273888891115E-8}, {0.2002267f, 1.0521983802642893E-8}, {0.20102575421333313, -8.152742388541905E-9}, {0.2018241584300995, -9.133484280193855E-9}, {0.2026219f, 8.59763959528144E-9}, {0.2034190595149994, -1.3548568223001414E-8}, {0.20421552658081055, 1.4847880344628818E-8}, {0.2050114f, 5.390620378060543E-9}, {0.2058066427707672, -1.1109834472051523E-8}, {0.20660123229026794, -3.845373872038116E-9}, {0.2073952f, -1.6149279479975042E-9}, {0.20818853378295898, -3.4174925203771133E-9}, {0.2089812457561493, -8.254443919468538E-9}, {0.2097733f, 1.4672790944499144E-8}, {0.2105647623538971, 6.753452542942992E-9}, {0.2113556f, -1.218609462241927E-9}, {0.2121458f, -8.254218316367887E-9}, {0.21293538808822632, -1.3366540360587255E-8}, {0.2137243151664734, 1.4231244750190031E-8}, {0.2145126760005951, -1.3885660525939072E-8}, {0.21530038118362427, -7.3304404046850136E-9}, {0.2160874605178833, 5.072117654842356E-9}, {0.21687394380569458, -5.505080220459036E-9}, {0.2176598f, -8.286782292266659E-9}, {0.2184450328350067, -2.302351152358085E-9}, {0.21922963857650757, 1.3416565858314603E-8}, {0.22001364827156067, 1.0033721426962048E-8}, {0.22079706192016602, -1.1487079818684332E-8}, {0.22157981991767883, 9.420348186357043E-9}, {0.2223619818687439, 1.4110645699377834E-8}, {0.2231435477733612, 3.5408485497116107E-9}, {0.22392448782920837, 8.468072777056227E-9}, {0.2247048318386078, 4.255446699237779E-11}, {0.22548454999923706, 9.016946273084244E-9}, {0.22626367211341858, 6.537034810260226E-9}, {0.2270422f, -6.451285264969768E-9}, {0.2278201f, 7.979956357126066E-10}, {0.2285974f, -5.759582672039005E-10}, {0.22937411069869995, -9.633854121180397E-9}, {0.2301502f, 4.363736368635843E-9}, {0.23092567920684814, 1.2549416560182509E-8}, {0.231700599193573, -1.3946383592553814E-8}, {0.2324748933315277, -1.458843364504023E-8}, {0.23324856162071228, 1.1551692104697154E-8}, {0.23402166366577148, 5.795621295524984E-9}, {0.23479416966438293, -1.1301979046684263E-9}, {0.23556607961654663, -8.303779721781787E-9}, {0.2363374f, -1.4805271785394075E-8}, {0.23710808157920837, 1.0085373835899469E-8}, {0.2378782033920288, 7.679117635349454E-9}, {0.2386477291584015, 8.69177352065934E-9}, {0.23941665887832642, 1.4034725764547136E-8}, {0.24018502235412598, -5.185064518887831E-9}, {0.2409527599811554, 1.1544236628121676E-8}, {0.24171993136405945, 5.523085719902123E-9}, {0.2424865f, 7.456824943331887E-9}, {0.24325251579284668, -1.1555923403029638E-8}, {0.2440179f, 8.988361382732908E-9}, {0.2447827160358429, 1.0381848020926893E-8}, {0.24554696679115295, -6.480706118857055E-9}, {0.24631062150001526, -1.0904271124793968E-8}, {0.2470736801624298, -1.998183061531611E-9}, {0.247836172580719, -8.676137737360023E-9}, {0.24859806895256042, -2.4921733203932487E-10}, {0.2493593990802765, -5.635173762130303E-9}, {0.2501201629638672, -2.3951455355985637E-8}, {0.2508803f, 5.287121672447825E-9}, {0.2516399025917053, -6.447877375049486E-9}, {0.2523989f, 1.32472428796441E-9}, {0.2531573176383972, 2.9479464287605006E-8}, {0.2539151906967163, 1.9284247135543574E-8}, {0.2546725273132324, -2.8390360197221716E-8}, {0.255429208278656, 6.533522495226226E-9}, {0.2561853528022766, 5.713225978895991E-9}, {0.2569409f, 2.9618050962556135E-8}, {0.2576959f, 1.950605015323617E-8}, {0.2584504f, -2.3762031507525576E-8}, {0.2592042088508606, 1.98818938195077E-8}, {0.25995755195617676, -2.751925069084042E-8}, {0.2607102394104004, 1.3703391844683932E-8}, {0.2614624f, 2.5193525310038174E-8}, {0.262214f, 7.802219817310385E-9}, {0.26296502351760864, 2.1983272709242607E-8}, {0.2637155055999756, 8.979279989292184E-9}, {0.2644653916358948, 2.9240221157844312E-8}, {0.265214741230011, 2.4004885823813374E-8}, {0.2659635543823242, -5.885186277410878E-9}, {0.2667117714881897, 1.4300386517357162E-11}, {0.2674594521522522, -1.7063531531989365E-8}, {0.26820653676986694, 3.3218524692903896E-9}, {0.2689530849456787, 2.3998252479954764E-9}, {0.2696990966796875, -1.8997462070389404E-8}, {0.2704445f, -4.350745270980051E-10}, {0.2711893916130066, -6.892221115467135E-10}, {0.27193373441696167, -1.89333199110902E-8}, {0.272677481174469, 5.262017392507765E-9}, {0.2734207f, 1.3115046679980076E-8}, {0.2741633653640747, 5.4468361834451975E-9}, {0.2749055027961731, -1.692337384653611E-8}, {0.27564704418182373, 6.426479056697412E-9}, {0.2763880491256714, 1.670735065191342E-8}, {0.27712851762771606, 1.4733029698334834E-8}, {0.27786844968795776, 1.315498542514467E-9}, {0.2786078453063965, -2.2735061539223372E-8}, {0.27934664487838745, 2.994379757313727E-9}, {0.2800849f, 1.970577274107218E-8}, {0.28082263469696045, 2.820392733542077E-8}, {0.2815598249435425, 2.929187356678173E-8}, {0.28229647874832153, 2.377086680926386E-8}, {0.2830325961112976, 1.2440393009992529E-8}, {0.2837681770324707, -3.901826104778096E-9}, {0.2845032215118408, -2.4459827842685974E-8}, {0.2852376699447632, 1.1165241398059789E-8}, {0.28597164154052734, -1.54434478239181E-8}, {0.28670501708984375, 1.5714110564653245E-8}, {0.28743791580200195, -1.3782394940142479E-8}, {0.2881702184677124, 1.6063569876284005E-8}, {0.28890204429626465, -1.317176818216125E-8}, {0.28963327407836914, 1.8504673536253893E-8}, {0.29036402702331543, -7.334319635123628E-9}, {0.29109418392181396, 2.9300903540317107E-8}, {0.2918238639831543, 9.979706999541057E-9}, {0.292553f, -4.916314210412424E-9}, {0.293281614780426, -1.4611908070155308E-8}, {0.2940096855163574, -1.833351586679361E-8}, {0.29473721981048584, -1.530926726615185E-8}, {0.2954642176628113, -4.7689754029101934E-9}, {0.29619067907333374, 1.4055868011423819E-8}, {0.296916663646698, -1.7672547212604003E-8}, {0.2976420521736145, 2.0020234215759705E-8}, {0.2983669638633728, 8.688424478730524E-9}, {0.2990913391113281, 8.69851089918337E-9}, {0.29981517791748047, 2.0810681643102672E-8}, {0.3005385398864746, -1.3821169493779352E-8}, {0.301261305809021, 2.4769140784919128E-8}, {0.3019835948944092, 1.8127576600610336E-8}, {0.3027053475379944, 2.6612401062437074E-8}, {0.3034266233444214, -8.629042891789934E-9}, {0.3041473627090454, -2.724174869314043E-8}, {0.30486756563186646, -2.8476975783775358E-8}, {0.3055872321128845, -1.1587600174449919E-8}, {0.3063063621520996, 2.417189020581056E-8}, {0.3070250153541565, 1.99407553679345E-8}, {0.3077431917190552, -2.35387025694381E-8}, {0.3084607720375061, 1.3683509995845583E-8}, {0.30917787551879883, 1.3137214081023085E-8}, {0.3098945f, -2.444006866174775E-8}, {0.3106105327606201, 2.0896888605749563E-8}, {0.31132614612579346, -2.893149098508887E-8}, {0.31204116344451904, 5.621509038251498E-9}, {0.3127557039260864, 6.0778104626050015E-9}, {0.3134697675704956, -2.6832941696716294E-8}, {0.31418323516845703, 2.6826625274495256E-8}, {0.3148963f, -1.1030897183911054E-8}, {0.3156088f, -2.047124671392676E-8}, {0.3163207769393921, -7.709990443086711E-10}, {0.3170322775840759, -1.0812918808112342E-8}, {0.3177432417869568, 9.727979174888975E-9}, {0.31845372915267944, 1.9658551724508715E-9}, {0.3191636800765991, 2.6222628001695826E-8}, {0.3198731541633606, 2.3609400272358744E-8}, {0.32058215141296387, -5.159602957634814E-9}, {0.3212906f, 2.329701319016099E-10}, {0.3219986f, -1.910633190395738E-8}, {0.32270604372024536, -2.863180390093667E-9}, {0.323413f, -9.934041364456825E-9}, {0.3241194486618042, 1.999240777687192E-8}, {0.3248254060745239, 2.801670341647724E-8}, {0.3255309f, 1.4842534265191358E-8}, {0.3262359f, -1.882789920477354E-8}, {0.3269403576850891, -1.268923579073577E-8}, {0.32764434814453125, -2.564688370677835E-8}, {0.3283478021621704, 2.6015626820520968E-9}, {0.32905077934265137, 1.3147747907784344E-8}, {0.3297532796859741, 6.686493860720675E-9}, {0.3304553f, -1.608884086544153E-8}, {0.3311568f, 5.118287907840204E-9}, {0.3318578004837036, 1.139367970944884E-8}, {0.3325583338737488, 3.426327822115399E-9}, {0.3332584f, -1.809622142990733E-8}, {0.3339579105377197, 7.116780143398601E-9}, {0.3346569538116455, 2.0145352306345386E-8}, {0.3353555202484131, 2.167272474431968E-8}, {0.3360536f, 1.2380696294966822E-8}, {0.33675122261047363, -7.050361059209181E-9}, {0.3374482989311218, 2.366314656322868E-8}, {0.3381449580192566, -1.4010540194086646E-8}, {0.3388410806655884, -1.860165465666482E-10}, {0.33953672647476196, 6.206776940880773E-9}, {0.3402319f, 5.841137379010982E-9}, {0.3409265875816345, -6.11041311179286E-10}, {0.3416208028793335, -1.2479264502054702E-8}, {0.34231454133987427, -2.909443297645926E-8}, {0.34300774335861206, 9.815805717097634E-9}, {0.3437005281448364, -1.4291517981101049E-8}, {0.3443927764892578, 1.8457821628427503E-8}, {0.3450846f, -1.0481908869377813E-8}, {0.3457759f, 1.876076001514746E-8}, {0.3464667797088623, -1.2362653723769037E-8}, {0.3471571207046509, 1.6016578405624026E-8}, {0.347847044467926, -1.4652759033760925E-8}, {0.3485364317893982, 1.549533655901835E-8}, {0.3492254f, -1.2093068629412478E-8}, {0.3499138355255127, 2.244531711424792E-8}, {0.35060185194015503, 5.538565518604807E-10}, {0.3512894f, -1.7511499366215853E-8}, {0.3519763946533203, 2.850385787215544E-8}, {0.35266298055648804, 2.003926370146842E-8}, {0.3533491f, 1.734665280502264E-8}, {0.3540347218513489, 2.1071983674869414E-8}, {0.35471993684768677, -2.774475773922311E-8}, {0.3554046154022217, -9.250975291734664E-9}, {0.3560888171195984, 1.7590672330295415E-8}, {0.3567726f, -6.1837904549178745E-9}, {0.3574559f, -2.0330362973820856E-8}, {0.3581387400627136, -2.42109990366786E-8}, {0.3588210940361023, -1.7188958587407816E-8}, {0.35950297117233276, 1.3711958590112228E-9}, {0.3601844310760498, -2.7501042008405925E-8}, {0.36086535453796387, 1.6036460343275798E-8}, {0.3615458607673645, 1.3405964389498495E-8}, {0.3622259f, 2.484237749027735E-8}, {0.3629055f, -8.629967484362177E-9}, {0.36358463764190674, -2.6778729562324134E-8}, {0.3642633f, -2.8977490516960565E-8}, {0.36494147777557373, -1.4601106624823502E-8}, {0.3656191825866699, 1.69742947894444E-8}, {0.3662964701652527, 6.7666740211281175E-9}, {0.36697328090667725, 1.500201674336832E-8}, {0.3676496744155884, -1.730424167425052E-8}, {0.36832553148269653, 2.9676011119845104E-8}, {0.36900103092193604, -2.2253590346826743E-8}, {0.369676f, 6.3372065441089185E-9}, {0.37035053968429565, -3.145816653215968E-9}, {0.3710246f, 9.515812117036965E-9}, {0.371698260307312, -1.4669965113042639E-8}, {0.3723714351654053, -1.548715389333397E-8}, {0.37304413318634033, 7.674361647125109E-9}, {0.3737164f, -4.181177882069608E-9}, {0.3743882179260254, 9.158530500130718E-9}, {0.3750596046447754, -1.13047236597869E-8}, {0.3757305145263672, -5.36108186384227E-9}, {0.3764009475708008, 2.7593452284747873E-8}, {0.37707096338272095, 2.8557016344085205E-8}, {0.3777405619621277, -1.868818164036E-9}, {0.3784096837043762, -3.479042513414447E-9}, {0.37907832860946655, 2.432550290565648E-8}, {0.37974655628204346, 2.2538131805476768E-8}, {0.38041436672210693, -8.244395239939089E-9}, {0.3810817003250122, -7.821867597227376E-9}, {0.3817485570907593, 2.4400089062515914E-8}, {0.382415f, 2.9410015940087773E-8}, {0.38308101892471313, 7.799913824734797E-9}, {0.38374656438827515, 1.976524624939355E-8}, {0.3844117f, 6.291008309266035E-9}, {0.3850763440132141, 2.757030889767851E-8}, {0.38574057817459106, 2.4585794728405612E-8}, {0.3864043951034546, -2.0764122246389383E-9}, {0.3870677351951599, 7.77328837578952E-9}, {0.3877306580543518, -4.8859560029989374E-9}, {0.3883931040763855, 2.0133131420595028E-8}, {0.38905513286590576, 2.380738071335498E-8}, {0.3897167444229126, 6.7171126157142075E-9}, {0.39037787914276123, 2.9046141593926277E-8}, {0.3910386562347412, -2.7836800219410262E-8}, {0.3916988968849182, 1.545909820981726E-8}, {0.39235877990722656, -1.930436269002062E-8}, {0.3930181860923767, -1.2343297554921835E-8}, {0.3936771750450134, -2.268889128622553E-8}, {0.3943357f, 9.835827818608177E-9}, {0.39499378204345703, 2.6197411946856397E-8}, {0.3956514596939087, 2.6965931069318893E-8}, {0.3963087201118469, 1.2710331127772166E-8}, {0.39696556329727173, -1.6001563011916016E-8}, {0.39762192964553833, 1.0016001590267064E-9}, {0.3982778787612915, 4.680767399874334E-9}, {0.3989334f, -4.399582029272418E-9}, {0.39958852529525757, -2.5676078228301587E-8}, {0.4002431631088257, 1.0181870233355787E-9}, {0.40089738368988037, 1.6639728835984655E-8}, {0.4015512f, 2.174860642202632E-8}, {0.40220457315444946, 1.6903781197123503E-8}, {0.40285754203796387, 2.663119647467697E-9}, {0.4035101f, -2.0416603812329616E-8}, {0.4041621685028076, 7.82494078472695E-9}, {0.40481382608413696, 2.833770747113627E-8}, {0.40546512603759766, -1.7929433274271985E-8}, {0.40611594915390015, -1.1214757379328965E-8}, {0.4067663550376892, -1.0571553019207106E-8}, {0.40741634368896484, -1.5449538712332313E-8}, {0.40806591510772705, -2.529950530235105E-8}, {0.408715f, 2.0031331601617008E-8}, {0.4093637466430664, 1.880755298741952E-9}, {0.41001206636428833, -1.9600580584843318E-8}, {0.4106599f, 1.573691633515306E-8}, {0.4113073945045471, -1.0772154376548336E-8}, {0.411954402923584, 2.0624330192486066E-8}, {0.4126010537147522, -8.741139170029572E-9}, {0.4132472276687622, 2.0881457123894216E-8}, {0.41389304399490356, -9.177488027521808E-9}, {0.4145383834838867, 2.0829952491625585E-8}, {0.4151833653450012, -7.767915492597301E-9}, {0.4158278703689575, 2.4774753446082082E-8}, {0.41647201776504517, -2.1581119071750435E-10}, {0.4171157479286194, -2.260047972865202E-8}, {0.417759f, 1.775884601423381E-8}, {0.4184019f, 2.185301053838889E-9}, {0.4190443754196167, -9.185071463667081E-9}, {0.4196864366531372, -1.5821896727910552E-8}, {0.4203280806541443, -1.719582086188318E-8}, {0.4209693f, -1.2778508303324259E-8}, {0.42161011695861816, -2.042639194493364E-9}, {0.4222505f, 1.5538093219698803E-8}, {0.4228905439376831, -1.9115659590156936E-8}, {0.4235301f, 1.3729680248843432E-8}, {0.4241693f, -4.611893838830296E-9}, {0.4248080849647522, -1.4013456880651706E-8}, {0.42544645071029663, -1.3953728897042917E-8}, {0.4260844f, -3.912427573594197E-9}, {0.4267219305038452, 1.6629734283189315E-8}, {0.4273591f, -1.1413593493354881E-8}, {0.42799586057662964, -2.792046157580119E-8}, {0.42863214015960693, 2.723009182661306E-8}, {0.42926812171936035, -2.4260535621557444E-8}, {0.42990362644195557, -3.064060124024764E-9}, {0.43053877353668213, -2.787640178598121E-8}, {0.4311734437942505, 2.102412085257792E-8}, {0.4318077564239502, 2.4939635093999683E-8}, {0.4324417f, -1.5619414792273914E-8}, {0.4330751895904541, 1.9065734894871523E-8}, {0.4337083101272583, 1.0294301092654604E-8}, {0.434341f, 1.8178469851136E-8}, {0.4349733591079712, -1.6379825102473853E-8}, {0.4356052279472351, 2.6334323946685834E-8}, {0.43623673915863037, 2.761628769925529E-8}, {0.436867892742157, -1.2030229087793677E-8}, {0.4374985694885254, 2.7106814809424793E-8}, {0.4381289f, 2.631993083235205E-8}, {0.43875885009765625, -1.3890028312254422E-8}, {0.43938833475112915, 2.6186133735555794E-8}, {0.4400174617767334, 2.783809071694788E-8}, {0.440646231174469, -8.436135220472006E-9}, {0.44127458333969116, -2.2534815932619883E-8}, {0.4419025182723999, -1.3961804471714283E-8}, {0.4425300359725952, 1.7778112039716255E-8}, {0.4431571960449219, 1.3574569976673652E-8}, {0.443784f, -2.607907890164073E-8}, {0.4444103240966797, 1.8518879652136628E-8}, {0.4450363f, 2.865065604247164E-8}, {0.4456619f, 4.806827797299427E-9}, {0.4462870955467224, 7.0816970994232115E-9}, {0.44691193103790283, -2.3640641240074437E-8}, {0.4475363492965698, -2.7267718387865538E-8}, {0.4481603503227234, -3.3126235292976077E-9}, {0.448784f, -1.0894001590268427E-8}, {0.4494072198867798, 1.0077883359971829E-8}, {0.4500300884246826, 4.825712712114668E-10}, {0.450652539730072, 2.0407987470746858E-8}, {0.4512746334075928, 1.073186581170719E-8}, {0.4518963694572449, -2.8064314757880205E-8}, {0.45251762866973877, 2.3709316816226527E-8}, {0.4531385898590088, -1.2281487504266522E-8}, {0.4537591338157654, -1.634864487421458E-8}, {0.45437926054000854, 1.1985747222409522E-8}, {0.45499902963638306, 1.3594057956219485E-8}, {0.4556184411048889, -1.1047585095328619E-8}, {0.45623743534088135, -1.8592937532754405E-9}, {0.4568560719490051, -1.797135137545755E-8}, {0.4574742913246155, 6.943684261645378E-10}, {0.4580921530723572, -4.994175141684681E-9}, {0.4587096f, 2.5039391215625133E-8}, {0.45932674407958984, -2.7943366835352838E-8}, {0.4599434f, 1.534146910128904E-8}, {0.4605598f, -2.3450920230816267E-8}, {0.46117573976516724, -2.4642997069960124E-8}, {0.4617912769317627, 1.2232622070370946E-8}, {0.4624064564704895, 2.80378133047839E-8}, {0.46302127838134766, 2.3238237048117092E-8}, {0.46363574266433716, -1.7013046451109475E-9}, {0.4642498f, 1.3287778803035383E-8}, {0.46486347913742065, 9.06393426961373E-9}, {0.4654768109321594, -1.3910598647592876E-8}, {0.46608972549438477, 4.430214458933614E-9}, {0.46670228242874146, 4.942270562885745E-9}, {0.4673144817352295, -1.1914734393460718E-8}, {0.4679262638092041, 1.3922696570638494E-8}, {0.4685377f, 2.3307929211781914E-8}, {0.46914875507354736, 1.669813444584674E-8}, {0.469759464263916, -5.450354376430758E-9}, {0.47036975622177124, 1.6922605350647674E-8}, {0.4709796905517578, 2.4667033200046904E-8}, {0.47158926725387573, 1.8236762070433784E-8}, {0.472198486328125, -1.915204563140137E-9}, {0.4728073f, 2.426795414605756E-8}, {0.4734157919883728, -2.19717006713618E-8}, {0.47402387857437134, -2.0974352165535873E-8}, {0.47463154792785645, 2.770970558184228E-8}, {0.4752389192581177, 5.32006955298355E-9}, {0.47584593296051025, -2.809054633964104E-8}, {0.4764525294303894, -1.2470243596102937E-8}, {0.4770587682723999, -6.977226702440138E-9}, {0.47766464948654175, -1.1165866833118273E-8}, {0.47827017307281494, -2.4591344661022708E-8}, {0.4788752794265747, 1.2794996377383974E-8}, {0.4794800877571106, -1.7772927065973874E-8}, {0.48008447885513306, 3.35657712457243E-9}, {0.4806885f, 1.7020465042442242E-8}, {0.481292188167572, 2.365953779624783E-8}, {0.4818955063819885, 2.3713798664443718E-8}, {0.4824984669685364, 1.7622455019548098E-8}, {0.4831010699272156, 5.823920246566496E-9}, {0.4837033152580261, -1.1244184344361017E-8}, {0.48430514335632324, 2.645961716432205E-8}, {0.4849066734313965, 1.6207809718247905E-10}, {0.4855077862739563, 2.9507744508973654E-8}, {0.4861086f, -4.278201128741098E-9}, {0.486709f, 1.844722015961139E-8}, {0.4873090982437134, -2.1092372471088425E-8}, {0.4879087805747986, -3.2555596107382053E-9}, {0.4885081f, 1.2784366845429667E-8}, {0.48910707235336304, 2.7457984659996047E-8}, {0.48970574140548706, -1.8409546441412518E-8}, {0.490304f, -5.179903818099661E-9}, {0.4909018874168396, 7.97053127828682E-9}, {0.4914994239807129, 2.146925464473481E-8}, {0.4920966625213623, -2.3861648589988232E-8}, {0.4926934838294983, -8.386923035320549E-9}, {0.4932899475097656, 8.713990131749256E-9}, {0.4938860535621643, 2.7865534085810115E-8}, {0.4944818615913391, -1.011325138560159E-8}, {0.4950772523880005, 1.4409851026316708E-8}, {0.495672345161438, -1.735227547472004E-8}, {0.49626702070236206, 1.4231078209064581E-8}, {0.4968614f, -9.628709342929729E-9}, {0.4974554181098938, -2.8907074856577267E-8}, {0.4980490207672119, 1.6419797090870802E-8}, {0.49864232540130615, 7.561041519403049E-9}, {0.49923527240753174, 4.538983468118194E-9}, {0.49982786178588867, 7.770560657946324E-9}, {0.500420093536377, 1.767197002609876E-8}, {0.5010119676589966, 3.46586694799214E-8}, {0.5016034841537476, 5.914537964556077E-8}, {0.5021947622299194, -2.7663203939320167E-8}, {0.5027855634689331, 1.3064749115929298E-8}, {0.5033761262893677, -5.667682106730711E-8}, {0.503966212272644, 1.9424534974370594E-9}, {0.5045560598373413, -4.908494602153544E-8}, {0.5051454305648804, 2.906989285008994E-8}, {0.5057345628738403, -1.602000800745108E-9}, {0.5063233375549316, -2.148245271118002E-8}, {0.5069117546081543, -3.016329994276181E-8}, {0.5074998140335083, -2.7237099632871992E-8}, {0.5080875158309937, -1.2297127301923986E-8}, {0.5086748600006104, 1.5062624834468093E-8}, {0.5092618465423584, 5.524744954836658E-8}, {0.5098485946655273, -1.054736327333046E-8}, {0.5104348659515381, 5.650063324725722E-8}, {0.5110208988189697, 1.8376017791642605E-8}, {0.5116065740585327, -5.309470636324855E-9}, {0.512191891670227, -1.4154089255217218E-8}, {0.5127768516540527, -7.756800301729815E-9}, {0.5133614540100098, 1.4282730618002001E-8}, {0.5139456987380981, 5.2364136172269755E-8}, {0.5145297050476074, -1.2322940607922115E-8}, {0.5151132345199585, 5.903831350855322E-8}, {0.5156965255737305, 2.8426856726994483E-8}, {0.5162794589996338, 1.544882070711032E-8}, {0.5168620347976685, 2.0500353979930155E-8}, {0.5174442529678345, 4.397691311390564E-8}, {0.5180262327194214, -3.2936025225250634E-8}, {0.5186077356338501, 2.857419553449673E-8}, {0.519189f, -9.51761338269325E-9}, {0.5197699069976807, -2.7609457648450225E-8}, {0.520350456237793, -2.5309316441333305E-8}, {0.5209306478500366, -2.2258513086839407E-9}, {0.5215104818344116, 4.203159541613745E-8}, {0.5220900774002075, -1.1356287358852729E-8}, {0.5226693153381348, -4.279090925831093E-8}, {0.5232481956481934, -5.188364552285819E-8}, {0.5238267183303833, -3.82465458937857E-8}, {0.5244048833847046, -1.4923330530645769E-9}, {0.5249826908111572, 5.8765598932137004E-8}, {0.5255602598190308, 2.3703896609663678E-8}, {0.5261374711990356, 1.2917117341231647E-8}, {0.5267143249511719, 2.6789862192139226E-8}, {0.527290940284729, -5.350322253112414E-8}, {0.5278670787811279, 1.0839714455426386E-8}, {0.528443f, -1.821729591343314E-8}, {0.5290185213088989, -2.1083014672301448E-8}, {0.5295937061309814, 2.623848491704216E-9}, {0.5301685333251953, 5.328392630534142E-8}, {0.5307431221008301, 1.206790586971942E-8}, {0.5313173532485962, -1.4356011804377797E-9}, {0.5318912267684937, 1.3152074173459994E-8}, {0.5324647426605225, 5.6208949382936426E-8}, {0.533038f, 8.90310227565917E-9}, {0.5336109399795532, -9.179458802504127E-9}, {0.5341835021972656, 2.337337845617735E-9}, {0.5347557067871094, 4.3828918300477925E-8}, {0.535327672958374, -3.5392250480081715E-9}, {0.53589928150177, -2.0183663375378704E-8}, {0.5364705324172974, -5.730898606435436E-9}, {0.537041425704956, 4.0191927599879235E-8}, {0.5376120805740356, -1.2522542401353875E-9}, {0.5381823778152466, -1.0482571326594316E-8}, {0.5387523174285889, 1.2871924223480165E-8}, {0.539322018623352, -5.002774317612589E-8}, {0.539891242980957, 3.960668706590162E-8}, {0.5404602289199829, 4.372568630242375E-8}, {0.541029f, -3.730232461206926E-8}, {0.5415972471237183, 3.5309026109857795E-8}, {0.5421652793884277, 2.3508325311148225E-8}, {0.5427329540252686, 4.6871403168921666E-8}, {0.5433003902435303, -1.3445113140270216E-8}, {0.5438674688339233, -3.786663982218041E-8}, {0.5444341897964478, -2.602850370608209E-8}, {0.5450005531311035, 2.2433348713144506E-8}, {0.5455666780471802, -1.1326936872620137E-8}, {0.5461324453353882, -7.737252533211342E-9}, {0.5466978549957275, 3.3564604642699844E-8}, {0.547263f, -6.269066061111782E-9}, {0.5478278398513794, -7.667998948729528E-9}, {0.5483922958374023, 2.9728170818998143E-8}, {0.5489565134048462, -1.2930091396008281E-8}, {0.5495203733444214, -1.607434968107079E-8}, {0.5500838756561279, 2.0653935146671156E-8}, {0.5506471395492554, -2.1596593091833788E-8}, {0.5512100458145142, -2.3259315921149476E-8}, {0.5517725944519043, 1.6022492496522704E-8}, {0.5523349046707153, -2.260433328226171E-8}, {0.5528968572616577, -1.957497997726303E-8}, {0.5534584522247314, 2.5465477111883854E-8}, {0.5540198087692261, -6.33792454933092E-9}, {0.554580807685852, 4.577835263278281E-9}, {0.5551414489746094, 5.856589221771548E-8}, {0.5557018518447876, 3.6769498759522324E-8}, {0.5562618970870972, 5.874989409410614E-8}, {0.5568217039108276, 5.649147309876989E-9}, {0.5573811531066895, -2.9726830960751796E-9}, {0.5579402446746826, 3.323458344853057E-8}, {0.5584990978240967, -4.588749093664028E-9}, {0.5590575933456421, 3.115616594184543E-9}, {0.5596157312393188, 5.6696103838614634E-8}, {0.5601736307144165, 3.7291263280048303E-8}, {0.5607312917709351, -5.4751646725093355E-8}, {0.5612884759902954, 1.9332630743320287E-8}, {0.5618454217910767, 2.147161515775941E-8}, {0.5624021291732788, -4.7989172862560625E-8}, {0.5629583597183228, 4.971378973445109E-8}, {0.5635144710540771, -4.2702997139152675E-8}, {0.5640701055526733, 3.273212962622764E-8}, {0.5646255016326904, 3.79438125545842E-8}, {0.5651806592941284, -2.6725298288329835E-8}, {0.5657354593276978, -4.1723833577410244E-8}, {0.5662899017333984, -6.71028256490915E-9}, {0.56684410572052, -4.055299181908475E-8}, {0.567397952079773, -2.3702295314000405E-8}, {0.5679514408111572, 4.4181618172507453E-8}, {0.5685046911239624, 4.4228706309734985E-8}, {0.5690577030181885, -2.3222346436879016E-8}, {0.5696103572845459, -3.862412756175274E-8}, {0.5701626539230347, -1.6390743801589046E-9}, {0.5707147121429443, -3.1139472791083883E-8}, {0.5712664127349854, -7.579587391156013E-9}, {0.5718178749084473, -4.983281844744412E-8}, {0.572369f, -3.835454246739619E-8}, {0.5729197263717651, 2.7190020372374008E-8}, {0.5734702348709106, 2.7925807446276126E-8}, {0.574020504951477, -3.5813506001861646E-8}, {0.5745704174041748, -4.448550564530588E-8}, {0.57512f, 2.2423840341717488E-9}, {0.5756692886352539, -1.450709904687712E-8}, {0.5762182474136353, 2.4806815282282017E-8}, {0.5767669677734375, 1.3057724436551892E-9}, {0.5773153305053711, 3.4529452510568104E-8}, {0.5778634548187256, 5.598413198183808E-9}, {0.5784112215042114, 3.405124925700107E-8}, {0.5789587497711182, 1.0074354568442952E-9}, {0.5795059204101562, 2.600448597385527E-8}, {0.5800528526306152, -9.83920263200211E-9}, {0.5805994272232056, 1.3012807963586057E-8}, {0.5811457633972168, -2.432215917965441E-8}, {0.5816917419433594, -2.308736892479391E-9}, {0.5822374820709229, -3.983067093146514E-8}, {0.5827828645706177, -1.735366061128156E-8}, {0.583328f, -5.376251584638963E-8}, {0.5838727951049805, -2.952399778965259E-8}, {0.5844172239303589, 5.5685313670430624E-8}, {0.5849615335464478, -3.6230268489088716E-8}, {0.5855053663253784, 5.267948957869391E-8}, {0.5860490798950195, -3.489144132234588E-8}, {0.5865923166275024, 5.9006122320612716E-8}, {0.5871354341506958, -2.2934896740542648E-8}, {0.5876781940460205, -4.1975650319859075E-8}, {0.5882205963134766, 2.2036094805348692E-9}, {0.5887627601623535, -9.287179048539306E-9}, {0.5893045663833618, 4.3079982556221595E-8}, {0.589846134185791, 4.041399585161321E-8}, {0.5903874635696411, -1.696746473863933E-8}, {0.5909284353256226, -9.53795080582038E-9}, {0.5914691686630249, -5.619010749352923E-8}, {0.5920095443725586, -3.7398514182529506E-8}, {0.5925495624542236, 4.71524479659295E-8}, {0.5930894613265991, -4.0640692434639215E-8}, {0.5936288833618164, 5.716453096255401E-8}, {0.5941681861877441, -1.6745661720946737E-8}, {0.5947071313858032, -2.3639110433141897E-8}, {0.5952457189559937, 3.67972590471072E-8}, {0.595784068107605, 4.566672575206695E-8}, {0.5963221788406372, 3.2813537149653483E-9}, {0.5968599319458008, 2.916199305533732E-8}, {0.5973974466323853, 4.410412409109416E-9}, {0.5979346036911011, 4.85464582112459E-8}, {0.5984715223312378, 4.267089756924666E-8}, {0.5990082025527954, -1.2906712010774655E-8}, {0.5995445251464844, 1.3319784467641742E-9}, {0.6000806093215942, -3.35137581974451E-8}, {0.6006163358688354, 2.0734340706476473E-9}, {0.6011518239974976, -1.0808162722402073E-8}, {0.601686954498291, 4.735781872502109E-8}, {0.6022218465805054, 5.76686738430634E-8}, {0.6027565002441406, 2.043049589651736E-8}, {0.6032907962799072, 5.515817703577808E-8}, {0.6038248538970947, 4.2947540692649586E-8}, {0.6043586730957031, -1.589678872195875E-8}, {0.6048921346664429, -1.8613847754677912E-9}, {0.6054253578186035, -3.3851886626187444E-8}, {0.6059582233428955, 7.64416021682279E-9}, {0.6064908504486084, 3.7201467248814224E-9}, {0.6070232391357422, -4.532172996647129E-8}, {0.6075552701950073, -1.997046552871766E-8}, {0.6080870628356934, -3.913411606668587E-8}, {0.6086184978485107, 1.6697361107868944E-8}, {0.609149694442749, 2.8614950293715483E-8}, {0.6096806526184082, -3.081552929643174E-9}, {0.6102112531661987, 4.111645931319645E-8}, {0.6107416152954102, 4.2298539553668435E-8}, {0.6112717390060425, 7.630546413718035E-10}, {0.6118015050888062, 3.601718675118614E-8}, {0.6123310327529907, 2.914906573537692E-8}, {0.6128603219985962, -1.9544361222269494E-8}, {0.613389253616333, 9.442671392695732E-9}, {0.6139179468154907, -2.8031202304593286E-9}, {0.6144464015960693, -5.598619958143586E-8}, {0.6149744987487793, -3.060220883766096E-8}, {0.6155023574829102, -4.556583652800433E-8}, {0.6160298585891724, 1.8626341656366314E-8}, {0.6165571212768555, 4.305870564227991E-8}, {0.6170841455459595, 2.8024460607734262E-8}, {0.6176109313964844, -2.6183651590639875E-8}, {0.6181373596191406, -6.406189112730307E-11}, {0.6186635494232178, -1.2534241706168776E-8}, {0.6191893815994263, 5.5906456251308664E-8}, {0.6197150945663452, -3.286964881802063E-8}, {0.6202404499053955, -4.0153537978961E-8}, {0.6207654476165771, 3.434477109643361E-8}, {0.6212903261184692, -4.750377491075032E-8}, {0.6218148469924927, -4.699152670372743E-8}, {0.622339f, 3.617013128065961E-8}, {0.6228630542755127, -3.6149218175202596E-8}, {0.6233867406845093, -2.5243286814648133E-8}, {0.6239101886749268, -5.003410681432538E-8}, {0.6244332790374756, 8.974417915105033E-9}, {0.6249561309814453, 3.285935446876949E-8}, {0.6254787445068359, 2.190661054038537E-8}, {0.6260011196136475, -2.3598354190515998E-8}, {0.6265231370925903, 1.5838762427747586E-8}, {0.6270449161529541, 2.129323729978037E-8}, {0.6275664567947388, -6.950808333865794E-9}, {0.6280876398086548, 5.059959203156465E-8}, {0.6286087036132812, -4.41909071122557E-8}, {0.6291294097900391, -5.262093550784066E-8}, {0.6296497583389282, 2.559185648444699E-8}, {0.63017f, -4.768920119497491E-8}, {0.6306898593902588, -3.376406008397877E-8}, {0.6312094926834106, -5.156097914033476E-8}, {0.6317287683486938, 1.840992392368355E-8}, {0.632247805595398, 5.721951534729663E-8}, {0.6327667236328125, -5.406177467045421E-8}, {0.6332851648330688, 4.247320713683124E-8}, {0.6338034868240356, -1.0524557502830645E-8}, {0.6343214511871338, 2.5641927558519502E-8}, {0.6348391771316528, 3.204135737993823E-8}, {0.6353566646575928, 8.951285029786536E-9}, {0.6358739137649536, -4.335116707228395E-8}, {0.6363908052444458, -5.380016714089483E-9}, {0.6369074583053589, 3.931710344901743E-9}, {0.6374238729476929, -1.5140150088220166E-8}, {0.6379399299621582, 5.688910024377372E-8}, {0.638455867767334, -1.8124135273572568E-8}, {0.6389714479446411, -1.486720391901626E-9}, {0.6394867897033691, -1.2133811978747018E-8}, {0.6400018930435181, -4.9791700939901716E-8}, {0.6405166387557983, 5.022188652837274E-9}, {0.6410311460494995, 3.337143177933685E-8}, {0.6415454149246216, 3.55284719912458E-8}, {0.6420594453811646, 1.1765332726757802E-8}, {0.6425732374191284, -3.7646381826067834E-8}, {0.6430866718292236, 6.773803682579552E-9}, {0.6435998678207397, 2.608736797081283E-8}, {0.6441128253936768, 2.056466263408266E-8}, {0.6446255445480347, -9.524376551107945E-9}, {0.6451379060745239, 5.5299060775883977E-8}, {0.6456501483917236, -2.3114497793159813E-8}, {0.6461620330810547, -6.077779731902102E-9}, {0.6466736793518066, -1.2531793589140273E-8}, {0.6471850872039795, -4.220866994206517E-8}, {0.6476961374282837, 2.4368339445199057E-8}, {0.6482070684432983, -5.095229574221907E-8}, {0.6487176418304443, -2.9485356677301627E-8}, {0.649228f, -3.0173901411577916E-8}, {0.649738073348999, -5.275210583909726E-8}, {0.6502478122711182, 2.2254737134350224E-8}, {0.6507574319839478, -4.330693978322885E-8}, {0.6512666940689087, -1.0753950588009912E-8}, {0.6517757177352905, 9.686179886293545E-10}, {0.6522845029830933, -7.875434494414498E-9}, {0.6527930498123169, -3.702271091849158E-8}, {0.6533012390136719, 3.2999073763758614E-8}, {0.6538093090057373, -3.5966064858620067E-8}, {0.654317f, -5.23735298540578E-9}, {0.6548244953155518, 6.237715351293023E-9}, {0.6553317308425903, -1.279462699936282E-9}, {0.6558387279510498, -2.7527887552743672E-8}, {0.6563453674316406, 4.696233317356646E-8}, {0.6568518877029419, -1.5967172745329108E-8}, {0.6573580503463745, 2.2361985518423144E-8}, {0.657863974571228, 4.2999935789083046E-8}, {0.6583696603775024, 4.620570188811826E-8}, {0.6588751077651978, 3.223791487908353E-8}, {0.659380316734314, 1.3548138612715822E-9}, {0.6598852872848511, -4.618575323863973E-8}, {0.6603899002075195, 9.082960673843353E-9}, {0.6608942747116089, 4.820873399634487E-8}, {0.6613985300064087, -4.776104368314602E-8}, {0.6619024276733398, -4.0151502150238136E-8}, {0.6624060869216919, -4.791602708710648E-8}, {0.6629093885421753, 4.8410188461165925E-8}, {0.6634125709533691, 1.0663697110471944E-8}, {0.6639155149459839, -4.1691464781797555E-8}, {0.66441810131073, 1.080835500478704E-8}, {0.664920449256897, 4.920784622407246E-8}, {0.6654226779937744, -4.544868396511241E-8}, {0.6659245491027832, -3.448944157854234E-8}, {0.6664261817932129, -3.6870882345139385E-8}, {0.6669275760650635, -5.234055273962444E-8}, {0.6674286127090454, 3.856291077979099E-8}, {0.6679295301437378, -2.327375671320742E-9}, {0.6684302091598511, -5.555080534042001E-8}, {0.6689305305480957, -1.6471487337453832E-9}, {0.6694306135177612, 4.042486803683015E-8}, {0.6699305772781372, -4.8293856891818295E-8}, {0.6704301834106445, -2.9134931730784303E-8}, {0.6709295511245728, -2.1058207594753368E-8}, {0.6714286804199219, -2.3814619551682855E-8}, {0.6719275712966919, -3.7155475428252136E-8}, {0.6724261045455933, 5.8376834484391746E-8}, {0.6729245185852051, 2.4611679969129262E-8}, {0.6734226942062378, -1.899407107267079E-8}, {0.6739205121994019, 4.7016079464436395E-8}, {0.6744182109832764, -1.5529608026276525E-8}, {0.6749155521392822, 3.203391672602453E-8}, {0.6754127740859985, -4.8465821804075345E-8}, {0.6759096384048462, -1.8364507801369988E-8}, {0.6764062643051147, 3.3739397633046517E-9}, {0.6769026517868042, 1.6994526063192333E-8}, {0.6773988008499146, 2.2741891590028428E-8}, {0.6778947114944458, 2.0860312877435047E-8}, {0.678390383720398, 1.1593703222523284E-8}, {0.678885817527771, -4.814386594291911E-9}, {0.679381f, -2.812076759125914E-8}, {0.6798759698867798, -5.808261186903479E-8}, {0.680370569229126, 2.4751837654582522E-8}, {0.6808650493621826, -1.7793890245755405E-8}, {0.6813591718673706, 5.294053246347931E-8}, {0.681853175163269, -1.2220826223585654E-9}, {0.6823468208312988, 5.8377876767612725E-8}, {0.6828403472900391, -6.437492120743254E-9}, {0.6833335161209106, 4.2990710043633113E-8}, {0.6838265657424927, -3.1516131027023284E-8}, {0.684319257736206, 8.70017386744679E-9}, {0.6848117113113403, 4.466959125843237E-8}, {0.6853040456771851, -4.25782656420497E-8}, {0.685796f, -1.4386267593671393E-8}, {0.6862877607345581, 1.0274494061148778E-8}, {0.686779260635376, 3.164186629229597E-8}, {0.6872705221176147, 4.995334552140326E-8}, {0.687761664390564, -5.3763211240398744E-8}, {0.6882524490356445, -4.0852427502515625E-8}, {0.688742995262146, -3.0287143914420064E-8}, {0.6892333030700684, -2.183125937905008E-8}, {0.6897233724594116, -1.524901992178814E-8}, {0.6902132034301758, -1.0305018010328949E-8}, {0.6907027959823608, -6.764191876212205E-9}, {0.6911921501159668, -4.391824838015402E-9}, {0.6916812658309937, -2.9535446262017846E-9}, {0.6921701431274414, -2.2153227096187463E-9}, {0.6926587820053101, -1.943473623641502E-9}};

            private lnMant() {
            }
        }
    }
}

