/* Copyright 2006 aQute SARL 
 * Licensed under the Apache License, Version 2.0, see http://www.apache.org/licenses/LICENSE-2.0 */
package aQute.bnd.plugin.popup.actions;

import java.io.*;
import java.util.Iterator;

import org.eclipse.core.resources.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

import aQute.bnd.plugin.Activator;
import aQute.lib.osgi.*;
import aQute.lib.osgi.eclipse.EclipseClasspath;

public class MakeBundle implements IObjectActionDelegate {
	IFile[]		locations;
	
	public MakeBundle(){}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		try {
			if ( locations!= null) {
				for (int i = 0; i < locations.length; i++) {
					File mf = locations[i].getLocation().toFile();
					try {
						// TODO of course we should get the classpath from
						// inside API ...
						IProject project = locations[i].getProject();
						File p = project.getLocation().toFile();
						
						
						// TODO for now we ignore the workspace and use the 
						// project parent directory

						Builder	builder = new Builder();
						EclipseClasspath	ecp = new EclipseClasspath(builder, p.getParentFile(), p);

						builder.setClasspath((File[])ecp.getClasspath().toArray(new File[0]));
						builder.setSourcepath((File[])ecp.getSourcepath().toArray(new File[0]));
						builder.setProperties(mf);
						String path = builder.getProperty("-output");
						if ( path == null ) {
							path = mf.getAbsolutePath().replaceAll("\\.bnd$",".jar");
						}
						new File(path).delete();
						
						builder.build();
						Jar jar = builder.getJar();
						if ( builder.getErrors().size() >  0 ) {
							Activator.getDefault().error( builder.getErrors() );
						} else {
							jar.write(new File(path));
							if ( builder.getWarnings().size() >  0 ) {
								Activator.getDefault().warning(builder.getWarnings());
							}
							else 
								Activator.getDefault().mesage("Saved as " + path );
						} 
						
					} catch( Exception e ) {
						e.printStackTrace();
						Activator.getDefault().error("While generating JAR " + locations[i], e);
					}
					locations[i].getParent().refreshLocal(1,null);
				}
			}
		}
		catch( Exception e ) {
			Activator.getDefault().error("Could not start Test View", e );
		}
	}

	 /**
		 * @see IActionDelegate#selectionChanged(IAction, ISelection)
		 */
	public void selectionChanged(IAction action, ISelection selection) {
		locations = getLocations(selection);
	}


	IFile[] getLocations(ISelection selection) {
		if (selection != null && (selection instanceof StructuredSelection)) {
			StructuredSelection ss = (StructuredSelection) selection;
			IFile[] result = new IFile[ss.size()];
			int n = 0;
			for (Iterator i = ss.iterator(); i.hasNext();) {
				result[n++] = (IFile) i.next();
			}
			return result;
		}
		return null;
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

}
