package aQute.bnd.ant;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;

import aQute.lib.reporter.*;

public class BaseTask extends Task implements Reporter {
	List	errors		= new ArrayList();
	List	warnings	= new ArrayList();
	List	progress	= new ArrayList();
	boolean	pedantic;

	public void error(String s) {
		errors.add(s);
	}

	public List getErrors() {
		return errors;
	}

	public List getProgress() {
		return progress;
	}

	public List getWarnings() {
		// TODO Auto-generated method stub
		return warnings;
	}

	public void progress(String s) {
		progress.add(s);
	}

	public void warning(String s) {
		warnings.add(s);
	}

	protected boolean report() {
		return report(this);
	}

	protected boolean report(Reporter reporter) {
		if (reporter.getWarnings().size() > 0) {
			System.err.println("Warnings");
			for (Iterator e = reporter.getWarnings().iterator(); e.hasNext();) {
				System.err.println(e.next());
			}
		}
		if (reporter.getErrors().size() > 0) {
			System.err.println("Progress before Errors");
			for (Iterator e = reporter.getProgress().iterator(); e.hasNext();) {
				System.err.println(e.next());
			}
			System.err.println("Errors");
			for (Iterator e = reporter.getErrors().iterator(); e.hasNext();) {
				System.err.println(e.next());
			}
			return true;
		}
		return false;
	}

	public static File getFile(File base, String file) {
		File f = new File(file);
		if (f.isAbsolute())
			return f;
		int n;

		f = base.getAbsoluteFile();
		while ((n = file.indexOf('/')) > 0) {
			String first = file.substring(0, n);
			file = file.substring(n + 1);
			if (first.equals(".."))
				f = f.getParentFile();
			else
				f = new File(f, first);
		}
		return new File(f, file);
	}

	protected List split(String dependsOn, String string) {
		if (dependsOn == null)
			return new ArrayList();

		return Arrays.asList(string.split("\\s*" + string + "\\s*"));
	}

	protected String join(List classpath, String string) {
		StringBuffer sb = new StringBuffer();
		String del = "";
		for (Iterator i = classpath.iterator(); i.hasNext();) {
			Object name = (Object) i.next();
			sb.append(del);
			sb.append(name);
			del = string;
		}
		return sb.toString();
	}

	public boolean isPedantic() {
		return pedantic;
	}

	public void setPedantic(boolean pedantic) {
		this.pedantic = pedantic;
	}

}
