package gen.authentication;

import aQute.openapi.provider.OpenAPIBase;
import aQute.openapi.provider.OpenAPIContext;
import aQute.openapi.security.api.OpenAPISecurityDefinition;
import java.util.Optional;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.time.Instant;
import java.time.LocalDate;
/**
 * 
 * <ul>
 * 
 * <li>{@link #unauthenticated() GET unauthenticated =  unauthenticated}
 * 
 * <li>{@link #google() GET /google =  google}
 * 
 * <li>{@link #basic() GET /basic =  basic}
 * 
 * </ul>
 * 
 */

@RequireAuthenticationBase
public abstract class AuthenticationBase extends OpenAPIBase {

public static final String BASE_PATH = "/authentication";

/**
 * 
 * GET unauthenticated = unauthenticated
 * 
   * @returns 200 / null
 * 200
 * 
 */

protected abstract void unauthenticated() throws Exception;

/**
 * 
 * GET /google = google
 * 
   * @returns 200 / null
 * 200
 * 
 */

protected abstract String google() throws Exception;

/**
 * 
 * GET /basic = basic
 * 
   * @returns 200 / null
 * 200
 * 
 */

protected abstract String basic() throws Exception;

  /*****************************************************************/



     public static OpenAPISecurityDefinition openid =  OpenAPISecurityDefinition.accessCode("openid", BASE_PATH, "", "" ,"openid","email");


     public static OpenAPISecurityDefinition google =  OpenAPISecurityDefinition.accessCode("google", BASE_PATH, "", "" ,"openid","email");


     public static OpenAPISecurityDefinition github =  OpenAPISecurityDefinition.accessCode("github", BASE_PATH, "", "" ,"user:email");


     public static OpenAPISecurityDefinition basic =  OpenAPISecurityDefinition.basic("basic",BASE_PATH);


  public AuthenticationBase() {
    super(BASE_PATH,gen.authentication.AuthenticationBase.class,
         "unauthenticated      GET    unauthenticated",
         "google               GET    /google  RETURN String",
         "basic                GET    /basic  RETURN String");
  }
  public static java.time.Instant toDateTime(String s) {
    return java.time.Instant.parse(s);
  }
  public static String fromDateTime(java.time.Instant s) {
    return s.toString();
  }
  public static LocalDate toDate(String s) {
    return LocalDate.parse(s);
  }
  public static String fromDate(LocalDate s) {
    return s.toString();
  }

  public boolean dispatch_(OpenAPIContext context, String segments[], int index ) throws Exception {

    if( index < segments.length && "basic".equals(segments[index])) {
      index++;
      if ( segments.length == index) {
        if ( context.isMethod(OpenAPIBase.Method.GET)) {
          basic_get_(context);
          return true;
        } 
        return getOpenAPIContext().doOptions("GET");

      }

      // end basic
    }  else     if( index < segments.length && "google".equals(segments[index])) {
      index++;
      if ( segments.length == index) {
        if ( context.isMethod(OpenAPIBase.Method.GET)) {
          google_get_(context);
          return true;
        } 
        return getOpenAPIContext().doOptions("GET");

      }

      // end google
    }  else     if( index < segments.length && "nauthenticated".equals(segments[index])) {
      index++;
      if ( segments.length == index) {
        if ( context.isMethod(OpenAPIBase.Method.GET)) {
          unauthenticated_get_(context);
          return true;
        } 
        return getOpenAPIContext().doOptions("GET");

      }

      // end nauthenticated
    } 

    return false;
  }

private void unauthenticated_get_(OpenAPIContext context) throws Exception{

    context.setOperation("unauthenticated");

    context.call( () -> { unauthenticated(); return null; });
    context.setResult(null, 200);

}

private void google_get_(OpenAPIContext context) throws Exception{

    context.setOperation("google");
    context.verify(gen.authentication.AuthenticationBase.google).verify();

    Object result = context.call( ()-> google());
    context.setResult(result, 200);

}

private void basic_get_(OpenAPIContext context) throws Exception{

    context.setOperation("basic");
    context.verify(gen.authentication.AuthenticationBase.basic).verify();

    Object result = context.call( ()-> basic());
    context.setResult(result, 200);

}

}


// aQute OpenAPI generator version 1.3.0.202007020625
