/**
 * Copyright 2014 Instil.
 */
package co.instil.dropwizard.filter;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Redirect insecure calls to use https.
 */
public class SslRedirectFilter implements Filter {
    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest) req;
            if (!request.isSecure()) {
                String redirectTarget = ((HttpServletRequest) req).getRequestURL().toString();
                redirectTarget = redirectTarget.replaceFirst("http", "https");
                ((HttpServletResponse) res).sendRedirect(redirectTarget);
                return;
            }
        }
        chain.doFilter(req, res);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }
}
