/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.util.webwork;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import ognl.OgnlException;
import ognl.OgnlRuntime;

public class ModelUrlBuilder {
    private String urlBase;
    private Object model;

    public ModelUrlBuilder(String urlBase) {
        this.urlBase = urlBase;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public String buildUrl() throws OgnlException, UnsupportedEncodingException {
        StringBuffer result = new StringBuffer(this.urlBase);
        if (this.urlBase.indexOf(63) < 0) {
            result.append('?');
        } else {
            result.append('&');
        }
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        if (stack == null) {
            stack = new OgnlValueStack();
            ActionContext.getContext().setValueStack(stack);
        }
        stack.push(this.model);
        stack.getContext().put(ModelUrlBuilder.class, ModelUrlBuilder.class);
        Map fields = OgnlRuntime.getFields(this.model.getClass());
        Iterator it = fields.keySet().iterator();
        while (it.hasNext()) {
            String[] value;
            String field = (String)it.next();
            if (fields.get(field).getClass().equals(Object.class) || (value = (String[])stack.findValue(field, String[].class)) == null || value.length <= 0) continue;
            for (int i = 0; i < value.length; ++i) {
                result.append(field);
                result.append('=');
                result.append(URLEncoder.encode(value[i], "UTF-8"));
                if (i >= value.length - 1) continue;
                result.append('&');
            }
            if (!it.hasNext()) continue;
            result.append('&');
        }
        stack.pop();
        stack.getContext().remove(ModelUrlBuilder.class);
        return result.toString();
    }
}

