/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.util.mail;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import net.incongru.util.mail.MailConfig;
import net.incongru.util.mail.Mailer;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityMailer
implements Mailer {
    private static final String PLAINTEXT_SUFFIX = "-text";
    private static final String HTML_SUFFIX = "-html";
    private VelocityEngine velocityEngine;
    private MailConfig config;

    public VelocityMailer(VelocityEngine velocityEngine, MailConfig config) {
        this.velocityEngine = velocityEngine;
        this.config = config;
    }

    public void mail(String toEmail, String toName, String subject, String templateName, Map values) throws Exception {
        VelocityContext ctx = new VelocityContext(values);
        String plainTextTemplateName = this.getPlainTextTemplateName(templateName);
        StringWriter plainText = new StringWriter();
        this.velocityEngine.mergeTemplate(plainTextTemplateName, "ISO-8859-15", (Context)ctx, (Writer)plainText);
        String htmlTemplateName = this.getHtmlTemplateName(templateName);
        if (htmlTemplateName != null) {
            StringWriter html = new StringWriter();
            this.velocityEngine.mergeTemplate(htmlTemplateName, "ISO-8859-15", (Context)ctx, (Writer)html);
            HtmlEmail email = new HtmlEmail();
            email.setHtmlMsg(html.getBuffer().toString());
            email.setTextMsg(plainText.getBuffer().toString());
            this.sendMail((Email)email, toEmail, toName, subject);
        } else {
            SimpleEmail email = new SimpleEmail();
            email.setMsg(plainText.getBuffer().toString());
            this.sendMail((Email)email, toEmail, toName, subject);
        }
    }

    protected void sendMail(Email email, String toEmail, String toName, String subject) throws Exception {
        email.setHostName(this.config.getMailHost());
        email.setFrom(this.config.getFromEmail(), this.config.getFromName());
        email.addTo(toEmail, toName);
        email.setSubject(subject);
        email.send();
    }

    String getPlainTextTemplateName(String templateName) {
        return this.getTemplateName(templateName, PLAINTEXT_SUFFIX, true);
    }

    String getHtmlTemplateName(String templateName) {
        return this.getTemplateName(templateName, HTML_SUFFIX, false);
    }

    private String getTemplateName(String templateName, String suffix, boolean useOriginalNameIfTemplateDoesNotExistWithSuffix) {
        String basename;
        String extension;
        int extIdx = templateName.lastIndexOf(46);
        if (extIdx < 0) {
            extension = ".vm";
            basename = templateName;
        } else {
            extension = templateName.substring(extIdx);
            basename = templateName.substring(0, extIdx);
        }
        String plainTextTemplateName = basename + suffix + extension;
        if (this.velocityEngine.templateExists(plainTextTemplateName)) {
            return plainTextTemplateName;
        }
        if (extIdx < 0 && this.velocityEngine.templateExists(plainTextTemplateName = basename + suffix)) {
            return plainTextTemplateName;
        }
        if (useOriginalNameIfTemplateDoesNotExistWithSuffix) {
            plainTextTemplateName = basename + extension;
            if (this.velocityEngine.templateExists(plainTextTemplateName)) {
                return plainTextTemplateName;
            }
            return templateName;
        }
        return null;
    }
}

