/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.profile;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.TextProviderSupport;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.incongru.berkano.app.ApplicationsProvider;
import net.incongru.berkano.profile.AbstractPreferencesAction;
import net.incongru.berkano.user.extensions.UserPropertyHelper;

public class PreferencesListAction
extends AbstractPreferencesAction {
    private transient TextProvider textProvider;

    public PreferencesListAction(ApplicationsProvider appProvider, UserPropertyHelper userPropertyHelper) {
        super(appProvider, userPropertyHelper);
    }

    public String execute() throws Exception {
        Object prefs = this.userPropertyHelper.getUserOnlyValue(this.getPreferenceKey());
        ActionContext.getContext().getValueStack().push(prefs);
        return super.execute();
    }

    public Collection getApps() {
        return this.appProvider.getAllApps();
    }

    public String getTranslatedAppName(String appName) {
        Class<?> clazz = this.appProvider.getApp(appName).getClass();
        return LocalizedTextUtil.findText(clazz, (String)appName, (Locale)this.getLocale());
    }

    private Class getAppClass() {
        return this.getApp().getClass();
    }

    private TextProvider getTextProvider() {
        if (this.textProvider == null) {
            this.textProvider = new TextProviderSupport(this.getAppClass(), (LocaleProvider)this);
        }
        return this.textProvider;
    }

    public String getText(String aTextName) {
        return this.getTextProvider().getText(aTextName);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.getTextProvider().getText(aTextName, defaultValue);
    }

    public String getText(String aTextName, List args) {
        return this.getTextProvider().getText(aTextName, args);
    }

    public String getText(String aTextName, String defaultValue, List args) {
        return this.getTextProvider().getText(aTextName, defaultValue, args);
    }

    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, stack);
    }

    public ResourceBundle getTexts() {
        return this.getTextProvider().getTexts();
    }

    public ResourceBundle getTexts(String aBundleName) {
        return this.getTextProvider().getTexts(aBundleName);
    }
}

