/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.profile;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.incongru.berkano.app.Application;
import net.incongru.berkano.app.ApplicationsProvider;
import net.incongru.berkano.app.PreferenceInfo;
import net.incongru.berkano.profile.AbstractPreferencesAction;
import net.incongru.berkano.user.extensions.UserPropertyHelper;

public class PreferencesListAction
extends AbstractPreferencesAction {
    public PreferencesListAction(ApplicationsProvider appProvider, UserPropertyHelper userPropertyHelper) {
        super(appProvider, userPropertyHelper);
    }

    public Collection getApps() {
        return this.appProvider.getAllApps();
    }

    public PreferenceInfo[] getPreferencesInfo() {
        Application app = this.appProvider.getApp(this.appName);
        return app.getPreferencesInfo();
    }

    public String getAppName(Application app) {
        Class<?> appClass = app.getClass();
        return this.getText(appClass, app.getName(), app.getName(), null, ActionContext.getContext().getValueStack());
    }

    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        Class appClass = this.getAppClass();
        return this.getText(appClass, key, defaultValue, args, stack);
    }

    private String getText(Class appClass, String key, String defaultValue, List args, OgnlValueStack stack) {
        if (appClass == null) {
            return super.getText(key, defaultValue, args, stack);
        }
        Object[] argsArray = args != null ? args.toArray(new Object[args.size()]) : null;
        return LocalizedTextUtil.findText((Class)appClass, (String)key, (Locale)this.getLocale(), (String)defaultValue, (Object[])argsArray, (OgnlValueStack)stack);
    }

    public ResourceBundle getTexts() {
        Class appClass = this.getAppClass();
        return appClass != null ? this.getTexts(appClass.getName()) : super.getTexts();
    }

    private Class getAppClass() {
        Application app = this.appProvider.getApp(this.appName);
        Class<?> appClass = app.getClass();
        return appClass;
    }
}

