/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.profile;

import com.opensymphony.webwork.views.jsp.ui.AbstractListTag;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.HashMap;
import java.util.Map;
import net.incongru.berkano.app.PreferenceInfo;
import net.incongru.berkano.app.PreferenceWidget;

public class PreferenceTag
extends AbstractListTag {
    private static final Map templatesMap = new HashMap();
    private PreferenceInfo preferenceInfo;

    public void evaluateParams(OgnlValueStack stack) {
        Object o = ActionContext.getContext().getValueStack().peek();
        if (!(o instanceof PreferenceInfo)) {
            throw new IllegalStateException("There should be a PreferenceInfo on top of the value stack!!");
        }
        this.preferenceInfo = (PreferenceInfo)o;
        this.setList("allowedValues");
        this.setName("keyName");
        String translatedPrefLabel = this.translate(this.findString("keyName"), stack);
        this.setLabel("'" + translatedPrefLabel + "'");
        super.evaluateParams(stack);
    }

    private String translate(String key, OgnlValueStack stack) {
        for (Object o : stack.getRoot()) {
            if (!(o instanceof TextProvider)) continue;
            TextProvider tp = (TextProvider)o;
            return tp.getText(key, key, null, stack);
        }
        return key;
    }

    protected String getDefaultTemplate() {
        if (this.preferenceInfo == null) {
            throw new IllegalStateException("PreferenceInfo should have been set!");
        }
        PreferenceWidget widget = this.preferenceInfo.getPreferenceWidget();
        return (String)templatesMap.get(widget);
    }

    static {
        templatesMap.put(PreferenceWidget.checkboxes, "checkboxlist");
        templatesMap.put(PreferenceWidget.dropdown, "select");
        templatesMap.put(PreferenceWidget.radios, "radiomap");
        templatesMap.put(PreferenceWidget.text, "text");
    }
}

