/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.tags.test;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import net.incongru.tags.test.JspTestServlet;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;

public abstract class JspTestCase
extends TestCase {
    private static final String ABS_PREFIX = "src/test/";
    private static final String RES_PREFIX = "/";

    private WebResponse setupJsp(String jsp) throws Throwable {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        ServletRunner sr = new ServletRunner();
        sr.registerServlet("jsp", JspTestServlet.class.getName());
        ServletUnitClient sc = sr.newClient();
        GetMethodWebRequest request = new GetMethodWebRequest("http://blah/jsp");
        request.setParameter("jsp", ABS_PREFIX + jsp);
        WebResponse response = sc.getResponse((WebRequest)request);
        JspTestCase.assertNotNull((String)"No response received", (Object)response);
        return response;
    }

    public void assertJspAsText(String expectedContent, String jsp) throws Throwable {
        WebResponse response = this.setupJsp(jsp);
        JspTestCase.assertEquals((String)expectedContent, (String)response.getText());
    }

    public void assertJspAsResource(String resourceName, String jsp, boolean ignoreWhiteSpace) throws Throwable {
        WebResponse res = this.setupJsp(jsp);
        InputStreamReader actualIn = new InputStreamReader(res.getInputStream());
        InputStream expectedInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(RES_PREFIX + resourceName);
        JspTestCase.assertNotNull((String)"can't get expected resource", (Object)expectedInputStream);
        InputStreamReader expectedIn = new InputStreamReader(expectedInputStream);
        this.compareText(expectedIn, actualIn, ignoreWhiteSpace);
    }

    public void compareText(Reader expected, Reader actual, boolean ignoreWhiteSpace) throws IOException {
        String actualLine;
        BufferedReader bExpected = new BufferedReader(expected);
        BufferedReader bActual = new BufferedReader(actual);
        StringBuffer actualBuffer = new StringBuffer();
        while (true) {
            String expectedLine = ignoreWhiteSpace ? this.getNextNotEmptyLine(bExpected) : bExpected.readLine();
            actualLine = ignoreWhiteSpace ? this.getNextNotEmptyLine(bActual) : bActual.readLine();
            actualBuffer.append(actualLine).append('\n');
            if (expectedLine == null) break;
            try {
                JspTestCase.assertEquals((String)expectedLine, (String)actualLine);
            }
            catch (AssertionFailedError e) {
                System.err.println("Actual content up until failure:");
                System.err.println(actualBuffer.toString());
                throw e;
            }
        }
        JspTestCase.assertNull((Object)actualLine);
    }

    private String getNextNotEmptyLine(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            return line;
        }
        return null;
    }

    static {
        BasicConfigurator.configure((Appender)new NullAppender());
    }
}

