/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.security.seraph.taglib;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import net.incongru.security.seraph.taglib.AbstractSecurityTag;

public class SecuredLinkTag
extends AbstractSecurityTag {
    private String href;
    private String title;
    private boolean alwaysOutputBody = false;

    public void setHref(String href) {
        this.href = href;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAlwaysOutputBody(boolean alwaysOutputBody) {
        this.alwaysOutputBody = alwaysOutputBody;
    }

    public void doTag() throws JspException, IOException {
        boolean granted = this.isUserAllowedPath(this.href);
        if (granted) {
            this.outputLink();
        } else if (this.alwaysOutputBody) {
            this.outputBody();
        }
    }

    private void outputLink() throws IOException, JspException {
        JspWriter out = this.getJspContext().getOut();
        out.write("<a href=\"");
        if (this.href.startsWith("/")) {
            out.write(this.getRequest().getContextPath());
        }
        out.write(this.href);
        out.write("\"");
        if (this.title != null) {
            out.write(" title=\"");
            out.write(this.title);
            out.write("\"");
        }
        out.write(">");
        this.outputBody(out);
        out.write("</a>");
    }
}

