/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.security.seraph.taglib;

import com.atlassian.seraph.SecurityService;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.service.PathService;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class AbstractSecurityTag
extends SimpleTagSupport {
    protected boolean isUserInRole(String requiredRole) {
        SecurityConfig securityConfig = this.getSecurityConfig();
        AuthenticationContext context = securityConfig.getAuthenticationContext();
        if (context == null) {
            return false;
        }
        RoleMapper roleMapper = securityConfig.getRoleMapper();
        boolean hasRole = roleMapper.hasRole(context.getUser(), this.getRequest(), requiredRole);
        return hasRole;
    }

    protected boolean isUserAllowedPath(String path) {
        SecurityConfig securityConfig = this.getSecurityConfig();
        List services = securityConfig.getServices();
        Iterator it = services.iterator();
        while (it.hasNext()) {
            SecurityService service = (SecurityService)it.next();
            if (!(service instanceof PathService)) continue;
            PathService pathService = (PathService)service;
            Set requiredRoles = pathService.getRequiredRoles(path);
            Iterator itRoles = requiredRoles.iterator();
            while (itRoles.hasNext()) {
                String role = (String)itRoles.next();
                if (this.isUserInRole(role)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalStateException("Could not find the PathService in Securityconfig");
    }

    protected HttpServletRequest getRequest() {
        return (HttpServletRequest)((PageContext)this.getJspContext()).getRequest();
    }

    protected SecurityConfig getSecurityConfig() {
        return (SecurityConfig)this.getJspContext().getAttribute("seraph_config", 4);
    }

    protected void outputBody() throws IOException, JspException {
        this.outputBody(this.getJspContext().getOut());
    }

    protected void outputBody(JspWriter out) throws IOException, JspException {
        this.getJspBody().invoke((Writer)out);
    }
}

