/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.nanocontainer.nanowar.ServletContainerFinder;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;

public class PicoFilterProxy
implements Filter {
    private static final int INIT_CONTEXT = 1;
    private static final int INIT_REQUEST = 4;
    private static final int INIT_NEVER = 7;
    private static final Map contextTypes = new HashMap();
    private int initType;
    private boolean lookupOnlyOnce;
    private FilterConfig filterConfig;
    private Filter delegate;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String initTypeStr = filterConfig.getInitParameter("init-type");
        Integer i = (Integer)contextTypes.get(initTypeStr);
        if (i == null) {
            throw new ServletException("Valid values for init-type are " + contextTypes.keySet());
        }
        this.initType = i;
        String lookupOnlyOneStr = filterConfig.getInitParameter("lookup-only-once");
        this.lookupOnlyOnce = "true".equals(lookupOnlyOneStr);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        if (this.delegate == null || !this.lookupOnlyOnce) {
            this.lookupDelegate((HttpServletRequest)req);
            if (this.initType == 1) {
                this.initDelegate();
            }
        }
        if (this.initType == 4) {
            this.initDelegate();
        }
        this.delegate.doFilter(req, res, filterChain);
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    private void lookupDelegate(HttpServletRequest req) throws ServletException {
        ServletContainerFinder picoFinder = new ServletContainerFinder();
        PicoContainer pico = picoFinder.findContainer(req);
        String delClassName = this.filterConfig.getInitParameter("delegate-class");
        String delKey = this.filterConfig.getInitParameter("delegate-key");
        if (delClassName != null) {
            try {
                Class<?> delClass = Class.forName(delClassName);
                this.delegate = (Filter)pico.getComponentInstanceOfType(delClass);
            }
            catch (ClassNotFoundException e) {
                throw new PicoInitializationException("Can not load " + delClassName + " : " + e.getMessage(), (Throwable)e);
            }
        } else if (delKey != null) {
            this.delegate = (Filter)pico.getComponentInstance((Object)delKey);
        } else {
            throw new PicoInitializationException("You must specify one of delegate-class or delegate-key in the filter config, and you must register the corresponding component in your picocontainer");
        }
        if (this.delegate == null) {
            throw new PicoInitializationException("Could not find component for " + delClassName + delKey);
        }
    }

    private void initDelegate() throws ServletException {
        if (this.delegate == null) {
            throw new IllegalStateException("Delegate filter was not set up!");
        }
        this.delegate.init(this.filterConfig);
    }

    static {
        contextTypes.put(null, new Integer(1));
        contextTypes.put("context", new Integer(1));
        contextTypes.put("request", new Integer(4));
        contextTypes.put("never", new Integer(7));
    }
}

