/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.ui;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HeaderFooterFilter
implements Filter {
    private String header;
    private String footer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.header = filterConfig.getInitParameter("header");
        this.footer = filterConfig.getInitParameter("footer");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        CharArrayServletResponseWrapper wrapper = new CharArrayServletResponseWrapper((HttpServletResponse)res);
        filterChain.doFilter(req, (ServletResponse)wrapper);
        String responseStr = wrapper.toString();
        try {
            if (this.header != null) {
                req.getRequestDispatcher(this.header).include(req, res);
            }
            res.getWriter().write(responseStr);
            if (this.footer != null) {
                req.getRequestDispatcher(this.footer).include(req, res);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.err);
        }
    }

    public void destroy() {
    }

    private class CharArrayServletResponseWrapper
    extends HttpServletResponseWrapper {
        private final CharArrayWriter writer;

        public CharArrayServletResponseWrapper(HttpServletResponse response) {
            super(response);
            this.writer = new CharArrayWriter();
        }

        public final PrintWriter getWriter() {
            return new PrintWriter(this.writer);
        }

        public final String toString() {
            return this.writer.toString();
        }
    }
}

