/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.bookmarks;

import java.io.Serializable;
import net.incongru.berkano.bookmarks.Bookmark;
import net.incongru.berkano.tree.Tree;
import net.incongru.berkano.tree.TreeIterator;
import net.incongru.berkano.tree.TreeNode;

public class BookmarksTree
implements Serializable {
    private Tree tree = new Tree();

    public Bookmark getBookmark(int bookmarkId) {
        TreeIterator it = this.tree.getTreeIterator();
        return this.searchBookmark(it, bookmarkId);
    }

    private Bookmark searchBookmark(TreeIterator it, int bookmarkId) {
        while (it.hasNext()) {
            Bookmark res;
            Bookmark bm = (Bookmark)it.next();
            if (bm.getId() == bookmarkId) {
                return bm;
            }
            if (!it.hasChildren() || (res = this.searchBookmark(it.getChildIterator(), bookmarkId)) == null) continue;
            return res;
        }
        return null;
    }

    public void moveTo(Bookmark bookmark, Bookmark parent) {
        TreeNode treeNode = this.tree.removeObject(bookmark);
        this.tree.addNode(treeNode, parent);
    }

    public void add(Bookmark bookmark, Bookmark parent) {
        this.tree.addObject((Object)bookmark, parent);
    }

    public void remove(Bookmark bookmark) {
        this.tree.removeObject(bookmark);
    }

    public void changeOrder(Bookmark bookmark, boolean up) {
        this.tree.changeOrder(bookmark, up);
    }

    protected Tree getTree() {
        return this.tree;
    }
}

