/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.bookmarks;

import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.incongru.berkano.bookmarks.BookmarksTree;
import net.incongru.berkano.bookmarks.HtmlListBookmarksWriter;

public class FreemarkerTransform
implements TemplateTransformModel {
    public Writer getWriter(Writer out, Map args) throws TemplateModelException, IOException {
        if (args == null || args.size() < 1 || args.size() > 3) {
            throw new TemplateModelException("supported args: bookmarks(mandatory), indent-start(optional) and indent-end(optional)");
        }
        BookmarksTree bookmarks = (BookmarksTree)args.get("bookmarks");
        if (bookmarks == null) {
            throw new TemplateModelException("bookmarks argument is mandatory");
        }
        String indentStart = (String)args.get("indent-start");
        String indentEnd = (String)args.get("indent-end");
        return new FreemarkerBookmarksTreeWriter(bookmarks, indentStart, indentEnd, out);
    }

    private static class FreemarkerBookmarksTreeWriter
    extends Writer {
        private BookmarksTree bookmarks;
        private String indentStart;
        private String indentEnd;
        private Writer out;
        private StringBuffer buff;

        public FreemarkerBookmarksTreeWriter(BookmarksTree bookmarks, String indentStart, String indentEnd, Writer out) {
            this.bookmarks = bookmarks;
            this.indentStart = indentStart;
            this.indentEnd = indentEnd;
            this.out = out;
            this.buff = new StringBuffer();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
            HtmlListBookmarksWriter bookmarksWriter = new HtmlListBookmarksWriter();
            bookmarksWriter.write(this.bookmarks, this.out);
            this.out.flush();
        }

        public void close() throws IOException {
        }
    }
}

